/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.item;

import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.entity.WoodenPaintingEntity;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public final class WoodenPaintingItem
extends HangingEntityItem
implements IWooden {
    private final IWoodType woodType;
    private final Supplier<EntityType<? extends WoodenPaintingEntity>> entityType;

    public WoodenPaintingItem(IWoodType woodType) {
        super(EntityType.f_20506_, new Item.Properties().m_41491_(CreativeModeTab.f_40750_));
        this.woodType = woodType;
        this.entityType = Suppliers.memoize(() -> (EntityType)ILikeWood.ENTITY_TYPE_REGISTRY.getObject(this.getWoodType(), WoodenEntityType.PAINTING));
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        BlockPos relative = clickedPos.m_121945_(clickedFace);
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        if (player != null && !this.m_5595_(player, clickedFace, itemStack, relative)) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        Optional<WoodenPaintingEntity> optional = WoodenPaintingEntity.create(level, relative, clickedFace, this.woodType, this.entityType.get());
        if (optional.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        HangingEntity hangingEntity = (HangingEntity)optional.get();
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)hangingEntity, (CompoundTag)tag);
        }
        if (hangingEntity.m_7088_()) {
            if (!level.f_46443_) {
                hangingEntity.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, hangingEntity.m_20182_());
                level.m_7967_((Entity)hangingEntity);
            }
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }
}

