/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.item.tiered;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import yamahari.ilikewood.item.tiered.IWoodenTieredItem;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodenItemTiers;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTier;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public final class WoodenHoeItem
extends HoeItem
implements IWooden,
IWoodenTieredItem {
    private final IWoodType woodType;
    private final IWoodenItemTier woodenItemTier;

    public WoodenHoeItem(IWoodType woodType, IWoodenItemTier woodenItemTier) {
        super((Tier)Tiers.WOOD, 0, 0.0f, woodenItemTier.equals(VanillaWoodenItemTiers.NETHERITE) ? new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41486_() : new Item.Properties().m_41491_(CreativeModeTab.f_40756_));
        this.woodType = woodType;
        this.woodenItemTier = woodenItemTier;
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return state.m_204336_(BlockTags.f_144281_) ? this.getWoodenItemTier().m_6624_() : 1.0f;
    }

    @Nonnull
    public Tier m_43314_() {
        return this.getWoodenItemTier();
    }

    public int m_6473_() {
        return this.getWoodenItemTier().m_6601_();
    }

    public boolean m_41465_() {
        return this.getMaxDamage(null) > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getWoodenItemTier().m_6609_();
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.getWoodenItemTier().m_6282_().test(repair);
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return this.getWoodenItemTier().getProperties(this.getTieredItemType()).getBurnTime();
    }

    public float m_41008_() {
        return this.getWoodenItemTier().m_6631_() + this.getWoodenItemTier().getProperties(this.getTieredItemType()).getAttackDamage();
    }

    public float getAttackSpeed() {
        return this.getWoodenItemTier().getProperties(this.getTieredItemType()).getAttackSpeed();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot equipmentSlot) {
        HashMultimap attributeModifiers = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            attributeModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_41008_(), AttributeModifier.Operation.ADDITION));
            attributeModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return attributeModifiers;
    }

    @Override
    public IWoodenItemTier getWoodenItemTier() {
        return this.woodenItemTier;
    }

    @Override
    public WoodenTieredItemType getTieredItemType() {
        return WoodenTieredItemType.HOE;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }
}

