/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.menu;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.data.recipe.AbstractWoodenSawmillRecipe;
import yamahari.ilikewood.registry.WoodenMenuTypes;
import yamahari.ilikewood.registry.WoodenRecipeTypes;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;

public final class WoodenSawmillMenu
extends AbstractContainerMenu {
    final Slot inputInventorySlot;
    final Slot outputInventorySlot;
    private final ContainerLevelAccess worldPosCallable;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final Level world;
    private Runnable inventoryUpdateListener = () -> {};
    private List<AbstractWoodenSawmillRecipe> recipes = Lists.newArrayList();
    private ItemStack itemStackInput = ItemStack.f_41583_;
    private long lastOnTake;
    public final Container inputInventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WoodenSawmillMenu.this.m_6199_((Container)this);
            WoodenSawmillMenu.this.inventoryUpdateListener.run();
        }
    };
    private final ResultContainer inventory = new ResultContainer();

    public WoodenSawmillMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WoodenSawmillMenu(int windowId, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)WoodenMenuTypes.WOODEN_SAWMILL.get(), windowId);
        this.worldPosCallable = worldPosCallable;
        this.world = playerInventory.f_35978_.f_19853_;
        this.inputInventorySlot = this.m_38897_(new Slot(this.inputInventory, 0, 20, 33));
        this.outputInventorySlot = this.m_38897_(new WoodenSawmillContainerOutputSlot((Container)this.inventory, 1, 143, 33, this));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<AbstractWoodenSawmillRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemInInputSlot() {
        return this.inputInventorySlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.worldPosCallable.m_39299_((world, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            return ILikeWood.BLOCK_REGISTRY.getObjects(WoodenBlockType.SAWMILL).anyMatch(arg_0 -> ((BlockState)blockState).m_60713_(arg_0)) && player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public boolean m_6366_(@Nonnull Player playerIn, int id) {
        if (this.isIdInRange(id)) {
            this.selectedRecipe.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isIdInRange(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public void m_6199_(@Nonnull Container inventoryIn) {
        ItemStack itemstack = this.inputInventorySlot.m_7993_();
        if (itemstack.m_41720_() != this.itemStackInput.m_41720_()) {
            this.itemStackInput = itemstack.m_41777_();
            this.setupRecipeList(inventoryIn, itemstack);
        }
    }

    private void setupRecipeList(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.world.m_7465_().m_44056_((RecipeType)WoodenRecipeTypes.SAWMILLING.get(), inventory, this.world);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isIdInRange(this.selectedRecipe.m_6501_())) {
            AbstractWoodenSawmillRecipe recipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.inventory.m_6029_((Recipe)recipe);
            this.outputInventorySlot.m_5852_(recipe.m_5874_(this.inputInventory));
        } else {
            this.outputInventorySlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @Nonnull
    public MenuType<?> m_6772_() {
        return (MenuType)WoodenMenuTypes.WOODEN_SAWMILL.get();
    }

    public void setInventoryUpdateListener(Runnable listener) {
        this.inventoryUpdateListener = listener;
    }

    public boolean m_5882_(@Nonnull ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.inventory && super.m_5882_(stack, slotIn);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            Item item = stackInSlot.m_41720_();
            itemstack = stackInSlot.m_41777_();
            if (index == 1) {
                item.m_7836_(stackInSlot, playerIn.f_19853_, playerIn);
                if (!this.m_38903_(stackInSlot, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, itemstack);
            } else if (index == 0 ? !this.m_38903_(stackInSlot, 2, 38, false) : (this.world.m_7465_().m_44015_((RecipeType)WoodenRecipeTypes.SAWMILLING.get(), (Container)new SimpleContainer(new ItemStack[]{stackInSlot}), this.world).isPresent() ? !this.m_38903_(stackInSlot, 0, 1, false) : (index < 29 ? !this.m_38903_(stackInSlot, 29, 38, false) : index < 38 && !this.m_38903_(stackInSlot, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stackInSlot.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, stackInSlot);
            this.m_38946_();
        }
        return itemstack;
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_8016_(1);
        this.worldPosCallable.m_39292_((world, blockPos) -> this.m_150411_(playerIn, this.inputInventory));
    }

    private static final class WoodenSawmillContainerOutputSlot
    extends Slot {
        private final WoodenSawmillMenu container;

        public WoodenSawmillContainerOutputSlot(Container inventoryIn, int index, int xPosition, int yPosition, WoodenSawmillMenu container) {
            super(inventoryIn, index, xPosition, yPosition);
            this.container = container;
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public void m_142406_(@Nonnull Player player, ItemStack stack) {
            stack.m_41678_(player.f_19853_, player, stack.m_41613_());
            this.container.inventory.m_8015_(player);
            ItemStack itemstack = this.container.inputInventorySlot.m_6201_(1);
            if (!itemstack.m_41619_()) {
                this.container.setupResultSlot();
            }
            this.container.worldPosCallable.m_39292_((world, blockPos) -> {
                long gameTime = world.m_46467_();
                if (this.container.lastOnTake != gameTime) {
                    world.m_5594_(null, blockPos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.container.lastOnTake = gameTime;
                }
            });
            super.m_142406_(player, stack);
        }
    }
}

