/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.plugin.vanilla;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import yamahari.ilikewood.ILikeWoodPlugin;
import yamahari.ilikewood.IModPlugin;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodTypes;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodenItemTiers;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodenResources;
import yamahari.ilikewood.registry.IWoodenObjectRegistry;
import yamahari.ilikewood.registry.IWoodenTieredItemRegistry;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.resource.IWoodenResourceRegistry;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTierRegistry;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.registry.woodtype.IWoodTypeRegistry;

@ILikeWoodPlugin
public class VanillaPlugin
implements IModPlugin {
    public static IWoodenObjectRegistry<Block, WoodenBlockType> BLOCK_REGISTRY;
    public static IWoodenObjectRegistry<Item, WoodenItemType> ITEM_REGISTRY;
    public static IWoodenObjectRegistry<Item, WoodenBlockType> BLOCK_ITEM_REGISTRY;
    public static IWoodenTieredItemRegistry TIERED_ITEM_REGISTRY;
    public static IWoodenObjectRegistry<EntityType<?>, WoodenEntityType> ENTITY_TYPES;

    @Override
    public String getModId() {
        return "ilikewood";
    }

    @Override
    public String getPluginModId() {
        return "ilikewood";
    }

    @Override
    public void registerWoodTypes(IWoodTypeRegistry registry) {
        VanillaWoodTypes.get().forEach(registry::register);
    }

    @Override
    public void registerWoodenItemTiers(IWoodenItemTierRegistry registry) {
        VanillaWoodenItemTiers.get().forEach(registry::register);
    }

    @Override
    public void registerWoodenResources(IWoodenResourceRegistry registry) {
        VanillaWoodTypes.get().forEach(woodType -> {
            registry.registerPlanksResource((IWoodType)woodType, VanillaWoodenResources.PLANKS.get(woodType));
            registry.registerLogResource((IWoodType)woodType, VanillaWoodenResources.LOGS.get(woodType));
            registry.registerStrippedLogResource((IWoodType)woodType, VanillaWoodenResources.STRIPPED_LOGS.get(woodType));
            registry.registerSlabResource((IWoodType)woodType, VanillaWoodenResources.SLABS.get(woodType));
        });
    }

    @Override
    public void acceptBlockRegistry(IWoodenObjectRegistry<Block, WoodenBlockType> registry) {
        BLOCK_REGISTRY = registry;
    }

    @Override
    public void acceptItemRegistry(IWoodenObjectRegistry<Item, WoodenItemType> registry) {
        ITEM_REGISTRY = registry;
    }

    @Override
    public void acceptBlockItemRegistry(IWoodenObjectRegistry<Item, WoodenBlockType> registry) {
        BLOCK_ITEM_REGISTRY = registry;
    }

    @Override
    public void acceptEntityTypeRegistry(IWoodenObjectRegistry<EntityType<?>, WoodenEntityType> registry) {
        ENTITY_TYPES = registry;
    }

    @Override
    public void acceptTieredItemRegistry(IWoodenTieredItemRegistry registry) {
        TIERED_ITEM_REGISTRY = registry;
    }
}

