/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.plugin.vanilla;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodTypes;
import yamahari.ilikewood.plugin.vanilla.util.resources.WoodenLogResource;
import yamahari.ilikewood.plugin.vanilla.util.resources.WoodenPlanksResource;
import yamahari.ilikewood.plugin.vanilla.util.resources.WoodenSlabResource;
import yamahari.ilikewood.plugin.vanilla.util.resources.WoodenStrippedLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenSlabResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class VanillaWoodenResources {
    public static final Map<IWoodType, IWoodenPlanksResource> PLANKS;
    public static final Map<IWoodType, IWoodenLogResource> LOGS;
    public static final Map<IWoodType, IWoodenStrippedLogResource> STRIPPED_LOGS;
    public static final Map<IWoodType, IWoodenSlabResource> SLABS;
    private static final Map<IWoodType, BlockBehaviour.Properties> PLANKS_PROPERTIES;

    private VanillaWoodenResources() {
    }

    private static String getLogPostFix(IWoodType woodType) {
        return woodType.equals(VanillaWoodTypes.CRIMSON) || woodType.equals(VanillaWoodTypes.WARPED) ? "stem" : "log";
    }

    static {
        PLANKS_PROPERTIES = new ImmutableMap.Builder().put((Object)VanillaWoodTypes.ACACIA, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)).put((Object)VanillaWoodTypes.BIRCH, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)).put((Object)VanillaWoodTypes.CRIMSON, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)).put((Object)VanillaWoodTypes.DARK_OAK, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)).put((Object)VanillaWoodTypes.JUNGLE, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)).put((Object)VanillaWoodTypes.MANGROVE, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_220865_)).put((Object)VanillaWoodTypes.OAK, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)).put((Object)VanillaWoodTypes.SPRUCE, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)).put((Object)VanillaWoodTypes.WARPED, (Object)BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50656_)).build();
        HashMap planks = new HashMap();
        HashMap logs = new HashMap();
        HashMap strippedLogs = new HashMap();
        HashMap slabs = new HashMap();
        VanillaWoodTypes.get().forEach(woodType -> {
            String logPostFix = VanillaWoodenResources.getLogPostFix(woodType);
            ResourceLocation planksResource = new ResourceLocation(Util.toRegistryName(woodType.getName(), "planks"));
            ResourceLocation logResource = new ResourceLocation(Util.toRegistryName(woodType.getName(), logPostFix));
            ResourceLocation strippedLogResource = new ResourceLocation(Util.toRegistryName("stripped", woodType.getName(), logPostFix));
            ResourceLocation slabResource = new ResourceLocation(Util.toRegistryName(woodType.getName(), "slab"));
            ResourceLocation planksTexture = new ResourceLocation(planksResource.m_135827_(), Util.toPath("block", planksResource.m_135815_()));
            planks.put(woodType, new WoodenPlanksResource(planksTexture, planksResource, PLANKS_PROPERTIES.get(woodType)));
            if (woodType.equals(VanillaWoodTypes.WARPED) || woodType.equals(VanillaWoodTypes.CRIMSON)) {
                logs.put(woodType, new WoodenLogResource(new ResourceLocation(logResource.m_135827_(), Util.toPath("block", Util.toRegistryName(logResource.m_135815_(), "top"))), new ResourceLocation(logResource.m_135827_(), Util.toPath("block", logResource.m_135815_())), logResource, new IWoodenLogResource.SideTextureProperties(true, true, 10)));
            } else {
                logs.put(woodType, new WoodenLogResource(new ResourceLocation(logResource.m_135827_(), Util.toPath("block", Util.toRegistryName(logResource.m_135815_(), "top"))), new ResourceLocation(logResource.m_135827_(), Util.toPath("block", logResource.m_135815_())), logResource));
            }
            strippedLogs.put(woodType, new WoodenStrippedLogResource(new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", Util.toRegistryName(strippedLogResource.m_135815_(), "top"))), new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", strippedLogResource.m_135815_())), strippedLogResource));
            slabs.put(woodType, new WoodenSlabResource(planksTexture, planksTexture, planksTexture, slabResource));
        });
        PLANKS = Collections.unmodifiableMap(planks);
        LOGS = Collections.unmodifiableMap(logs);
        STRIPPED_LOGS = Collections.unmodifiableMap(strippedLogs);
        SLABS = Collections.unmodifiableMap(slabs);
    }
}

