/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.post.WoodenStrippedPostBlock;
import yamahari.ilikewood.registry.objecttype.AbstractWoodenObjectType;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public abstract class AbstractBlockStateProvider
extends BlockStateProvider {
    private final WoodenBlockType blockType;

    public AbstractBlockStateProvider(DataGenerator generator, ExistingFileHelper helper, WoodenBlockType blockType) {
        super(generator, "ilikewood", helper);
        this.blockType = blockType;
    }

    protected final void registerStatesAndModels() {
        if (this.blockType.equals(WoodenBlockType.WHITE_BED)) {
            ILikeWood.BLOCK_REGISTRY.getObjects(WoodenBlockType.getBeds()).forEach(this::registerStateAndModel);
        } else {
            ILikeWood.BLOCK_REGISTRY.getObjects(this.blockType).forEach(this::registerStateAndModel);
        }
    }

    @Nonnull
    public final String m_6055_() {
        return String.format("%s - block states & models - %s", "ilikewood", this.blockType.getName());
    }

    protected final ModelFile templateWithPlanks(Block block, WoodenBlockType ... blockTypes) {
        return this.templateWithPlanks(block, "", blockTypes);
    }

    protected final ModelFile templateWithPlanks(Block block, String nested, WoodenBlockType ... blockTypes) {
        return this.templateWithPlanks(block, nested, Util.toPath("block", Arrays.stream(blockTypes).map(AbstractWoodenObjectType::getName).collect(Collectors.joining("/"))));
    }

    protected final ModelFile templateWithPlanks(Block block, String nested, String path) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String name = ((IWooden)block).getWoodType().getName();
        ResourceLocation planks = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType).getTexture();
        return this.models().singleTexture(Util.toPath(path + nested, woodType.getModId(), name), this.modLoc(Util.toPath(path + nested, "template")), "planks", planks);
    }

    protected final void postBlock(MultiPartBlockStateBuilder builder, ModelFile post, ModelFile side) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)WoodenStrippedPostBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Y}).end().part().modelFile(post).rotationY(90).rotationX(90).addModel()).condition((Property)WoodenStrippedPostBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.X}).end().part().modelFile(post).rotationX(90).addModel()).condition((Property)WoodenStrippedPostBlock.f_55923_, (Comparable[])new Direction.Axis[]{Direction.Axis.Z}).end();
        PipeBlock.f_55154_.forEach((direction, property) -> {
            if (direction.m_122434_().m_122479_()) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)direction.m_122435_() + 180) % 360).uvLock(false).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true});
            } else {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationX(direction == Direction.UP ? 270 : 90).uvLock(false).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true});
            }
        });
    }

    public abstract void registerStateAndModel(Block var1);
}

