/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenBedBlock;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class BedBlockStateProvider
extends AbstractBlockStateProvider {
    public BedBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.WHITE_BED);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        DyeColor color = ((WoodenBedBlock)block).getDyeColor();
        String path = Util.toPath("block", "bed");
        ResourceLocation planks = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType).getTexture();
        ResourceLocation frame = this.modLoc(Util.toPath(path, woodType.getModId(), "frame", woodType.getName()));
        ResourceLocation headTop = this.modLoc(Util.toPath(path, "sheets", "head", "top", color.toString()));
        ResourceLocation headSides = this.modLoc(Util.toPath(path, "sheets", "head", "sides", color.toString()));
        ResourceLocation footTop = this.modLoc(Util.toPath(path, "sheets", "foot", "top", color.toString()));
        ResourceLocation footSides = this.modLoc(Util.toPath(path, "sheets", "foot", "sides", color.toString()));
        BlockModelBuilder head = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "head", color.toString(), woodType.getName()), this.modLoc(Util.toPath(path, "head", "template")))).texture("planks", planks)).texture("frame", frame)).texture("top", headTop)).texture("sides", headSides);
        BlockModelBuilder foot = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "foot", color.toString(), woodType.getName()), this.modLoc(Util.toPath(path, "foot", "template")))).texture("planks", planks)).texture("frame", frame)).texture("top", footTop)).texture("sides", footSides);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "inventory", color.toString(), woodType.getName()), this.modLoc(Util.toPath(path, "inventory", "template")))).texture("planks", planks)).texture("frame", frame)).texture("head_top", headTop)).texture("head_sides", headSides)).texture("foot_top", footTop)).texture("foot_sides", footSides);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(((BedPart)state.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD) ? head : foot)).rotationY((((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() + 2) % 4 * 90).uvLock(false).build());
    }
}

