/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenCampfireBlock;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public class CampfireBlockStateProvider
extends AbstractBlockStateProvider {
    public CampfireBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.CAMPFIRE);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String path = Util.toPath("block", WoodenBlockType.CAMPFIRE.getName());
        IWoodenLogResource log = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        ResourceLocation logPileEnd = this.modLoc(Util.toPath("block", WoodenBlockType.LOG_PILE.getName(), woodType.getModId(), woodType.getName()));
        BlockModelBuilder off = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "off", woodType.getName()), this.modLoc(Util.toPath(path, "off", "template")))).texture("log_pile_end", logPileEnd)).texture("log_side", log.getSideTexture());
        BlockModelBuilder on = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), woodType.getName()), this.modLoc(Util.toPath(path, "template")))).texture("fire", this.mcLoc(Util.toPath("block", "campfire_fire")))).texture("log_pile_end", logPileEnd)).texture("log_side", log.getSideTexture())).texture("campfire_log_lit", this.modLoc(Util.toPath(path, "log_lit", "template")));
        HashMap<DyeColor, BlockModelBuilder> colored = new HashMap<DyeColor, BlockModelBuilder>();
        for (DyeColor color : DyeColor.values()) {
            colored.put(color, (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), color.m_41065_(), woodType.getName()), this.modLoc(Util.toPath(path, "template")))).texture("fire", this.modLoc(Util.toPath(path, "fire", color.m_41065_())))).texture("log_pile_end", logPileEnd)).texture("log_side", log.getSideTexture())).texture("campfire_log_lit", this.modLoc(Util.toPath(path, "log_lit", color.m_41065_()))));
        }
        this.getVariantBuilder(block).forAllStates(state -> {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)WoodenCampfireBlock.COLORED) != false ? (ModelFile)colored.get(state.m_61143_(WoodenCampfireBlock.COLOR)) : on)).rotationY((((Direction)state.m_61143_((Property)CampfireBlock.f_51230_)).m_122416_() + 2) % 4 * 90).uvLock(false).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)off).rotationY((((Direction)state.m_61143_((Property)CampfireBlock.f_51230_)).m_122416_() + 2) % 4 * 90).uvLock(false).build();
        });
    }
}

