/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class ItemFrameBlockStateProvider
extends BlockStateProvider {
    public ItemFrameBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "ilikewood", helper);
    }

    protected void registerStatesAndModels() {
        ILikeWood.ITEM_REGISTRY.getObjects(WoodenItemType.ITEM_FRAME).forEach(this::registerItemFrame);
    }

    @Nonnull
    public String m_6055_() {
        return String.format("%s - block states & models - %s", "ilikewood", WoodenItemType.ITEM_FRAME.getName());
    }

    private void registerItemFrame(Item item) {
        IWoodType woodType = ((IWooden)item).getWoodType();
        String path = Util.toPath("block", WoodenItemType.ITEM_FRAME.getName());
        ResourceLocation planks = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType).getTexture();
        ((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), woodType.getName()), this.modLoc(Util.toPath(path, "template")))).texture("planks", planks);
        ((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "map", woodType.getName()), this.modLoc(Util.toPath(path, "map", "template")))).texture("planks", planks);
    }
}

