/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class LogPileBlockStateProvider
extends AbstractBlockStateProvider {
    public LogPileBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.LOG_PILE);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        IWoodenLogResource logResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        String path = Util.toPath("block", WoodenBlockType.LOG_PILE.getName());
        ModelBuilder logPile = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), woodType.getName()), this.modLoc(Util.toPath(path, "template")))).texture("log_side", logResource.getSideTexture())).texture("log_pile_end", this.modLoc(Util.toPath(path, woodType.getModId(), woodType.getName())));
        this.horizontalBlock(block, (ModelFile)logPile);
    }
}

