/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenSawmillBlock;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class SawmillBlockStateProvider
extends AbstractBlockStateProvider {
    public SawmillBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.SAWMILL);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        IWoodenPlanksResource planksResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType);
        IWoodenLogResource logResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        IWoodenStrippedLogResource strippedLogResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType);
        String path = Util.toPath("block", WoodenBlockType.SAWMILL.getName());
        ResourceLocation logPile = this.modLoc(Util.toPath("block", WoodenBlockType.LOG_PILE.getName(), woodType.getModId(), woodType.getName()));
        BlockModelBuilder bottomLeft = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "bottom", "left", woodType.getName()), this.modLoc(Util.toPath(path, "bottom", "left", "template")))).texture("log_end", logResource.getEndTexture())).texture("log_side", logResource.getSideTexture())).texture("stripped_log_side", strippedLogResource.getSideTexture())).texture("log_pile", logPile);
        BlockModelBuilder bottomRight = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "bottom", "right", woodType.getName()), this.modLoc(Util.toPath(path, "bottom", "right", "template")))).texture("log_end", logResource.getEndTexture())).texture("log_side", logResource.getSideTexture())).texture("stripped_log_side", strippedLogResource.getSideTexture())).texture("log_pile", logPile);
        BlockModelBuilder topLeft = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "top", "left", woodType.getName()), this.modLoc(Util.toPath(path, "top", "left", "template")))).texture("planks", planksResource.getTexture());
        ModelFile.UncheckedModelFile topRight = new ModelFile.UncheckedModelFile(this.modLoc(Util.toPath(path, "top", "right", "template")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "inventory", woodType.getName()), this.modLoc(Util.toPath(path, "inventory", "template")))).texture("log_end", logResource.getEndTexture())).texture("log_side", logResource.getSideTexture())).texture("stripped_log_side", strippedLogResource.getSideTexture())).texture("planks", planksResource.getTexture())).texture("log_pile", logPile);
        EnumMap<WoodenSawmillBlock.WoodenSawmillModel, Object> models = new EnumMap<WoodenSawmillBlock.WoodenSawmillModel, Object>(WoodenSawmillBlock.WoodenSawmillModel.class);
        models.put(WoodenSawmillBlock.WoodenSawmillModel.BOTTOM_LEFT, bottomLeft);
        models.put(WoodenSawmillBlock.WoodenSawmillModel.BOTTOM_RIGHT, bottomRight);
        models.put(WoodenSawmillBlock.WoodenSawmillModel.TOP_LEFT, topLeft);
        models.put(WoodenSawmillBlock.WoodenSawmillModel.TOP_RIGHT, topRight);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)models.get(state.m_61143_(WoodenSawmillBlock.MODEL))).rotationY((((Direction)state.m_61143_((Property)WoodenSawmillBlock.HORIZONTAL_FACING)).m_122416_() + 2) % 4 * 90).uvLock(false).build());
    }
}

