/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class SingleDresserBlockStateProvider
extends AbstractBlockStateProvider {
    public SingleDresserBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.SINGLE_DRESSER);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        IWoodenStrippedLogResource strippedLogResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType);
        IWoodenLogResource logResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        IWoodenPlanksResource planksResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType);
        String path = Util.toPath("block", "dresser", "single");
        ModelBuilder chair = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), woodType.getName()), this.modLoc(Util.toPath(path, "template")))).texture("stripped_log_side", strippedLogResource.getSideTexture())).texture("planks", planksResource.getTexture())).texture("log_side", logResource.getSideTexture())).texture("log_end", logResource.getEndTexture());
        this.horizontalBlock(block, (ModelFile)chair);
    }
}

