/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class StrippedPostBlockStateProvider
extends AbstractBlockStateProvider {
    public StrippedPostBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.STRIPPED_POST);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String name = woodType.getName();
        String path = Util.toPath("block", WoodenBlockType.POST.getName());
        ResourceLocation strippedLog = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType).getSideTexture();
        BlockModelBuilder post = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, "stripped", woodType.getModId(), name), this.modLoc(Util.toPath(path, "template")))).texture("wall", strippedLog);
        BlockModelBuilder side = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, "stripped", woodType.getModId(), "side", name), this.modLoc(Util.toPath(path, "side", "template")))).texture("texture", this.modLoc(Util.toPath(path, "stripped", woodType.getModId(), name)));
        ((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, "stripped", woodType.getModId(), "inventory", name), this.modLoc(Util.toPath(path, "inventory", "template")))).texture("wall", strippedLog);
        this.postBlock(this.getMultipartBuilder(block), (ModelFile)post, (ModelFile)side);
    }
}

