/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenTableBlock;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class TableBlockStateProvider
extends AbstractBlockStateProvider {
    public TableBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.TABLE);
    }

    private static void tableConditions(Supplier<MultiPartBlockStateBuilder.PartBuilder> builder, int[] is) {
        for (int i : is) {
            builder.get().condition((Property)WoodenTableBlock.NORTH, (Comparable[])new Boolean[]{(i & 1) != 0}).condition((Property)WoodenTableBlock.EAST, (Comparable[])new Boolean[]{(i & 2) != 0}).condition((Property)WoodenTableBlock.SOUTH, (Comparable[])new Boolean[]{(i & 4) != 0}).condition((Property)WoodenTableBlock.WEST, (Comparable[])new Boolean[]{(i & 8) != 0});
        }
    }

    private static void nwLeg(MultiPartBlockStateBuilder builder, ModelFile leg) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leg).addModel(), new int[]{15, 13, 11, 6, 9, 2, 4, 0});
    }

    private static void neLeg(MultiPartBlockStateBuilder builder, ModelFile leg) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leg).rotationY(90).addModel(), new int[]{15, 7, 11, 3, 12, 4, 8, 0});
    }

    private static void seLeg(MultiPartBlockStateBuilder builder, ModelFile leg) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leg).rotationY(180).addModel(), new int[]{15, 7, 14, 6, 9, 1, 8, 0});
    }

    private static void swLeg(MultiPartBlockStateBuilder builder, ModelFile leg) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(leg).rotationY(270).addModel(), new int[]{15, 14, 13, 3, 12, 1, 2, 0});
    }

    private static void legs(MultiPartBlockStateBuilder builder, ModelFile leg) {
        TableBlockStateProvider.nwLeg(builder, leg);
        TableBlockStateProvider.neLeg(builder, leg);
        TableBlockStateProvider.seLeg(builder, leg);
        TableBlockStateProvider.swLeg(builder, leg);
    }

    private static void nBeam(MultiPartBlockStateBuilder builder, ModelFile beam) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(beam).addModel(), new int[]{14, 6, 12, 10, 2, 4, 8, 0});
    }

    private static void eBeam(MultiPartBlockStateBuilder builder, ModelFile beam) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(beam).rotationY(90).addModel(), new int[]{13, 12, 9, 5, 1, 4, 8, 0});
    }

    private static void sBeam(MultiPartBlockStateBuilder builder, ModelFile beam) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(beam).rotationY(180).addModel(), new int[]{11, 3, 9, 10, 1, 2, 8, 0});
    }

    private static void wBeam(MultiPartBlockStateBuilder builder, ModelFile beam) {
        TableBlockStateProvider.tableConditions(() -> (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(beam).rotationY(270).addModel(), new int[]{7, 3, 6, 5, 1, 2, 4, 0});
    }

    private static void beams(MultiPartBlockStateBuilder builder, ModelFile beam) {
        TableBlockStateProvider.nBeam(builder, beam);
        TableBlockStateProvider.eBeam(builder, beam);
        TableBlockStateProvider.sBeam(builder, beam);
        TableBlockStateProvider.wBeam(builder, beam);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String name = woodType.getName();
        String path = Util.toPath("block", WoodenBlockType.TABLE.getName());
        IWoodenLogResource log = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        IWoodenStrippedLogResource strippedLog = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType);
        BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "top", name), this.modLoc(Util.toPath(path, "top", "template")))).texture("log_end", log.getEndTexture())).texture("log_side", log.getSideTexture());
        BlockModelBuilder leg = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "leg", name), this.modLoc(Util.toPath(path, "leg", "template")))).texture("log_end", log.getEndTexture())).texture("stripped_log_side", strippedLog.getSideTexture());
        BlockModelBuilder beam = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "beam", name), this.modLoc(Util.toPath(path, "beam", "template")))).texture("log_end", log.getEndTexture())).texture("stripped_log_side", strippedLog.getSideTexture());
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "inventory", name), this.modLoc(Util.toPath(path, "inventory", "template")))).texture("log_end", log.getEndTexture())).texture("log_side", log.getSideTexture())).texture("stripped_log_side", strippedLog.getSideTexture());
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)top).addModel()).end();
        TableBlockStateProvider.legs(builder, (ModelFile)leg);
        TableBlockStateProvider.beams(builder, (ModelFile)beam);
    }
}

