/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.blockstate;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.blockstate.AbstractBlockStateProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class WallBlockStateProvider
extends AbstractBlockStateProvider {
    public WallBlockStateProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, helper, WoodenBlockType.WALL);
    }

    @Override
    public void registerStateAndModel(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String name = woodType.getName();
        String path = Util.toPath("block", WoodenBlockType.WALL.getName());
        ResourceLocation log = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType).getSideTexture();
        ResourceLocation strippedLog = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType).getSideTexture();
        BlockModelBuilder post = (BlockModelBuilder)this.models().wallPost(Util.toPath(path, woodType.getModId(), "post", name), log);
        BlockModelBuilder side = (BlockModelBuilder)this.models().wallSide(Util.toPath(path, woodType.getModId(), "side", name), strippedLog);
        BlockModelBuilder sideTall = (BlockModelBuilder)this.models().wallSideTall(Util.toPath(path, woodType.getModId(), "side_tall", name), strippedLog);
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.toPath(path, woodType.getModId(), "inventory", name), this.modLoc(Util.toPath(path, "inventory", "template")))).texture("post", log)).texture("side", strippedLog);
        this.wallBlock((WallBlock)block, (ModelFile)post, (ModelFile)side, (ModelFile)sideTall);
    }
}

