/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.itemmodel.blockitem;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public abstract class AbstractBlockItemModelProvider
extends ItemModelProvider {
    private final WoodenBlockType blockType;

    public AbstractBlockItemModelProvider(DataGenerator generator, ExistingFileHelper helper, WoodenBlockType blockType) {
        super(generator, "ilikewood", helper);
        this.blockType = blockType;
    }

    protected void registerModels() {
        if (this.blockType == WoodenBlockType.WHITE_BED) {
            ILikeWood.BLOCK_REGISTRY.getObjects(WoodenBlockType.getBeds()).forEach(this::registerModel);
        } else {
            ILikeWood.BLOCK_REGISTRY.getObjects(this.blockType).forEach(this::registerModel);
        }
    }

    protected abstract void registerModel(Block var1);

    protected void blockItem(Block block, String path) {
        String woodType = ((IWooden)block).getWoodType().getName();
        ((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block), "Registry name was null.").m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc(Util.toPath("block", path, woodType))));
    }

    @Nonnull
    public String m_6055_() {
        return String.format("%s - block item models - %s", "ilikewood", this.blockType.getName());
    }
}

