/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.lang;

import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.IObjectType;
import yamahari.ilikewood.registry.objecttype.IObjectTypeVisitor;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.util.Util;

public class DefaultLanguageProvider
extends LanguageProvider
implements IObjectTypeVisitor {
    private final IObjectType objectType;

    public DefaultLanguageProvider(DataGenerator generator, IObjectType objectType) {
        super(generator, "ilikewood", "en_us");
        this.objectType = objectType;
    }

    protected void addTranslations() {
        this.objectType.acceptVisitor(this);
    }

    @Override
    public boolean visit(WoodenBlockType blockType) {
        ILikeWood.BLOCK_REGISTRY.getObjects(blockType).forEach(block -> this.add((Block)block, Util.toTranslationName(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).m_135815_())));
        return true;
    }

    @Override
    public boolean visit(WoodenItemType itemType) {
        ILikeWood.ITEM_REGISTRY.getObjects(itemType).forEach(item -> this.add((Item)item, Util.toTranslationName(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135815_())));
        return true;
    }

    @Override
    public boolean visit(WoodenTieredItemType tieredItemType) {
        ILikeWood.TIERED_ITEM_REGISTRY.getObjects(tieredItemType).forEach(tieredItem -> this.add((Item)tieredItem, Util.toTranslationName(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(tieredItem)).m_135815_())));
        return true;
    }

    @Override
    public boolean visit(WoodenEntityType entityType) {
        return false;
    }
}

