/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.loot;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public final class DefaultBlockLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTables;
    private final String name;

    public DefaultBlockLootTableProvider(DataGenerator generator, Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>> supplier, String name) {
        super(generator);
        this.lootTables = ImmutableList.of((Object)Pair.of(supplier, (Object)LootContextParamSets.f_81421_));
        this.name = name;
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return this.lootTables;
    }

    protected void validate(@Nonnull Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext context) {
        map.forEach((location, lootTable) -> LootTables.m_79202_((ValidationContext)context, (ResourceLocation)location, (LootTable)lootTable));
    }

    public String m_6055_() {
        return String.format("%s - loot tables - %s", "ilikewood", this.name);
    }
}

