/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.recipe.blockitem;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenBedBlock;
import yamahari.ilikewood.provider.recipe.blockitem.AbstractBlockItemRecipeProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class BedRecipeProvider
extends AbstractBlockItemRecipeProvider {
    public BedRecipeProvider(DataGenerator generator) {
        super(generator, WoodenBlockType.WHITE_BED);
    }

    @Override
    protected void registerRecipes(@Nonnull Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block) {
        DyeColor color = ((WoodenBedBlock)block).getDyeColor();
        ItemLike wool = Util.getIngredient(Util.toRegistryName(color.toString().toUpperCase(), "WOOL"), Blocks.class);
        Block panels = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS);
        ItemLike dye = Util.getIngredient(Util.toRegistryName(color.toString().toUpperCase(), "DYE"), Items.class);
        ShapedRecipeBuilder.m_126116_((ItemLike)block).m_126127_(Character.valueOf('#'), Objects.requireNonNull(wool)).m_126127_(Character.valueOf('X'), (ItemLike)panels).m_126130_("###").m_126130_("XXX").m_126132_("has_wool", (CriterionTriggerInstance)BedRecipeProvider.m_125977_((ItemLike)wool)).m_126145_(String.format("%s:%s", "ilikewood", "beds")).m_126140_(consumer, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)));
        if (!color.equals((Object)DyeColor.WHITE)) {
            try {
                Block whiteBed = ILikeWood.getBlock(woodType, WoodenBlockType.WHITE_BED);
                ShapelessRecipeBuilder.m_126189_((ItemLike)block).m_126209_((ItemLike)whiteBed).m_126209_(Objects.requireNonNull(dye)).m_126132_("has_dye", (CriterionTriggerInstance)BedRecipeProvider.m_125977_((ItemLike)dye)).m_126145_(String.format("%s:%s", "ilikewood", "beds")).m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), "from", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)whiteBed.m_5456_())).m_135815_())));
            }
            catch (IllegalArgumentException ignored) {
                ILikeWood.LOGGER.info("White bed was not present for white<->color recipe!");
            }
        } else {
            WoodenBlockType.getBeds().filter(bedBlockType -> !bedBlockType.equals(WoodenBlockType.WHITE_BED)).forEach(bedBlockType -> {
                try {
                    Block coloredBed = ILikeWood.getBlock(woodType, bedBlockType);
                    ShapelessRecipeBuilder.m_126189_((ItemLike)block).m_126209_((ItemLike)coloredBed).m_126209_(Objects.requireNonNull(dye)).m_126132_("has_dye", (CriterionTriggerInstance)BedRecipeProvider.m_125977_((ItemLike)dye)).m_126145_(String.format("%s:%s", "ilikewood", "beds")).m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), "from", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)coloredBed.m_5456_())).m_135815_())));
                }
                catch (IllegalArgumentException ignored) {
                    ILikeWood.LOGGER.info("Colored bed was not present for white<->color recipe!");
                }
            });
        }
    }
}

