/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.recipe.item.tiered;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.item.tiered.IWoodenTieredItem;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodenItemTiers;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class NetheriteTieredItemRecipeProvider
extends RecipeProvider {
    private final WoodenTieredItemType tieredItemType;

    public NetheriteTieredItemRecipeProvider(DataGenerator generator, WoodenTieredItemType tieredItemType) {
        super(generator);
        this.tieredItemType = tieredItemType;
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
        ILikeWood.TIERED_ITEM_REGISTRY.getObjects(this.tieredItemType).filter(tieredItem -> ((IWoodenTieredItem)tieredItem).getWoodenItemTier().equals(VanillaWoodenItemTiers.DIAMOND)).forEach(tieredItem -> this.registerRecipes(consumer, (Item)tieredItem));
    }

    private void registerRecipes(@Nonnull Consumer<FinishedRecipe> consumer, Item item) {
        IWoodenTieredItem tieredItem = (IWoodenTieredItem)item;
        IWoodType woodType = ((IWooden)item).getWoodType();
        try {
            Item output = ILikeWood.TIERED_ITEM_REGISTRY.getObject(VanillaWoodenItemTiers.NETHERITE, woodType, tieredItem.getTieredItemType());
            UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (Item)output).m_126389_("has_netherite_ingot", (CriterionTriggerInstance)NetheriteTieredItemRecipeProvider.m_125977_((ItemLike)Items.f_42418_)).m_126395_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output)).m_135815_(), "smithing")));
        }
        catch (IllegalArgumentException ignored) {
            ILikeWood.LOGGER.info("No netherite tiered item found for diamond<->netherite smithing recipe!");
        }
    }

    @Nonnull
    public String m_6055_() {
        return String.format("%s - netherite %s", "ilikewood", this.tieredItemType.getName());
    }
}

