/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.recipe.sawmilling;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.config.ILikeWoodConfig;
import yamahari.ilikewood.data.condition.ConfigCondition;
import yamahari.ilikewood.registry.WoodenRecipeSerializers;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class SawmillingRecipeProvider
extends RecipeProvider {
    public SawmillingRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    private static SingleItemRecipeBuilder sawmillingRecipe(Ingredient ingredient, ItemLike result) {
        return SawmillingRecipeProvider.sawmillingRecipe(ingredient, result, 1);
    }

    private static SingleItemRecipeBuilder sawmillingRecipe(Ingredient ingredient, ItemLike result, int count) {
        return new SingleItemRecipeBuilder((RecipeSerializer)WoodenRecipeSerializers.SAWMILLING.get(), ingredient, result, count);
    }

    private static void panelsRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.PANELS) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.PANELS)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block panels = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS);
            String panelsPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)panels)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)panels, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.PANELS_CONFIG.name())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(panelsPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void panelsSlabRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count, @Nullable ICondition condition) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.PANELS_SLAB) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.PANELS_SLAB)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block panelsSlab = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS_SLAB);
            String panelsSlabPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)panelsSlab)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)panelsSlab, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.Builder conditionalBuilder = ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.PANELS_SLABS_CONFIG.name()));
            if (condition != null) {
                conditionalBuilder.addCondition(condition);
            }
            conditionalBuilder.addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(panelsSlabPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void panelsStairsRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count, @Nullable ICondition condition) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.PANELS_STAIRS) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.PANELS_STAIRS)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block panelsStairs = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS_STAIRS);
            String panelsStairsPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)panelsStairs)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)panelsStairs, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.Builder conditionalBuilder = ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.PANELS_STAIRS_CONFIG.name()));
            if (condition != null) {
                conditionalBuilder.addCondition(condition);
            }
            conditionalBuilder.addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(panelsStairsPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void stickRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count, @Nullable ICondition condition) {
        if (woodType.getItemTypes().contains(WoodenItemType.STICK) || woodType.getBuiltinItemTypes().contains(WoodenItemType.STICK)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Item stick = ILikeWood.getItem(woodType, WoodenItemType.STICK);
            String stickPath = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stick)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)stick, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.Builder conditionalBuilder = ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.STICKS_CONFIG.name()));
            if (condition != null) {
                conditionalBuilder.addCondition(condition);
            }
            conditionalBuilder.addRecipe(arg_0 -> ((SingleItemRecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(stickPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void wallRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.WALL) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.WALL)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block wall = ILikeWood.getBlock(woodType, WoodenBlockType.WALL);
            String wallPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)wall)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)wall, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.WALLS_CONFIG.name())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(wallPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void postRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.POST) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.POST)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block post = ILikeWood.getBlock(woodType, WoodenBlockType.POST);
            String postPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)post)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)post, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.POSTS_CONFIG.name())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(postPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void strippedPostRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.STRIPPED_POST) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.STRIPPED_POST)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block strippedPost = ILikeWood.getBlock(woodType, WoodenBlockType.STRIPPED_POST);
            String strippedPostPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)strippedPost)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)strippedPost, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.POSTS_CONFIG.name())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(strippedPostPath, "from", blockPath, "sawmilling")));
        }
    }

    private static void logPileRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count) {
        if (woodType.getBlockTypes().contains(WoodenBlockType.LOG_PILE) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.LOG_PILE)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block logPile = ILikeWood.getBlock(woodType, WoodenBlockType.LOG_PILE);
            String logPilePath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)logPile)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)logPile, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            ConditionalRecipe.builder().addCondition((ICondition)new ConfigCondition(ILikeWoodConfig.LOG_PILE_CONFIG.name())).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(logPilePath, "from", blockPath, "sawmilling")));
        }
    }

    private static void planksRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count, @Nullable ICondition condition) {
        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasPlanks(woodType)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block planks = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks(woodType).getResource()));
            String planksPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)planks)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)planks, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            if (condition == null) {
                builder.m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(planksPath, "from", blockPath, "sawmilling")));
            } else {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(planksPath, "from", blockPath, "sawmilling")));
            }
        }
    }

    private static void slabRecipe(Consumer<FinishedRecipe> consumer, IWoodType woodType, Block block, int count, @Nullable ICondition condition) {
        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasSlab(woodType)) {
            String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            Block slab = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getSlab(woodType).getResource()));
            String slabPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)slab)).m_135815_();
            SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)slab, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
            if (condition == null) {
                builder.m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(slabPath, "from", blockPath, "sawmilling")));
            } else {
                ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((SingleItemRecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(slabPath, "from", blockPath, "sawmilling")));
            }
        }
    }

    private static void vanillaStickRecipe(Consumer<FinishedRecipe> consumer, Block block, int count, @Nullable ICondition condition) {
        String blockPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
        String stickPath = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)Items.f_42398_)).m_135815_();
        SingleItemRecipeBuilder builder = SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block}), (ItemLike)Items.f_42398_, count).m_126132_(String.format("has_%s", blockPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)block));
        if (condition == null) {
            builder.m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(stickPath, "from", blockPath, "sawmilling")));
        } else {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((RecipeBuilder)builder).m_176498_(arg_0)).build(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(stickPath, "from", blockPath, "sawmilling")));
        }
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> consumer) {
        ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().forEach(woodType -> {
            ConfigCondition condition;
            if (woodType.getBlockTypes().contains(WoodenBlockType.PANELS) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.PANELS)) {
                Block panels = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS);
                condition = new ConfigCondition(ILikeWoodConfig.PANELS_CONFIG.name());
                SawmillingRecipeProvider.panelsSlabRecipe(consumer, woodType, panels, 2, condition);
                SawmillingRecipeProvider.panelsStairsRecipe(consumer, woodType, panels, 1, condition);
                SawmillingRecipeProvider.stickRecipe(consumer, woodType, panels, 2, condition);
                SawmillingRecipeProvider.vanillaStickRecipe(consumer, panels, 2, condition);
                SawmillingRecipeProvider.planksRecipe(consumer, woodType, panels, 1, condition);
                SawmillingRecipeProvider.slabRecipe(consumer, woodType, panels, 2, condition);
            }
            if (woodType.getBlockTypes().contains(WoodenBlockType.PANELS_SLAB) || woodType.getBuiltinBlockTypes().contains(WoodenBlockType.PANELS_SLAB)) {
                Block panelsSlab = ILikeWood.getBlock(woodType, WoodenBlockType.PANELS_SLAB);
                condition = new ConfigCondition(ILikeWoodConfig.PANELS_SLABS_CONFIG.name());
                SawmillingRecipeProvider.slabRecipe(consumer, woodType, panelsSlab, 1, condition);
            }
            if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasPlanks((IWoodType)woodType)) {
                Block planks = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks((IWoodType)woodType).getResource()));
                SawmillingRecipeProvider.panelsRecipe(consumer, woodType, planks, 1);
                SawmillingRecipeProvider.panelsSlabRecipe(consumer, woodType, planks, 2, null);
                SawmillingRecipeProvider.panelsStairsRecipe(consumer, woodType, planks, 1, null);
                SawmillingRecipeProvider.stickRecipe(consumer, woodType, planks, 2, null);
                SawmillingRecipeProvider.slabRecipe(consumer, woodType, planks, 2, null);
                SawmillingRecipeProvider.vanillaStickRecipe(consumer, planks, 2, null);
            }
            if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasSlab((IWoodType)woodType)) {
                Block slab = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getSlab((IWoodType)woodType).getResource()));
                SawmillingRecipeProvider.panelsSlabRecipe(consumer, woodType, slab, 1, null);
            }
            if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasLog((IWoodType)woodType)) {
                Block log = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog((IWoodType)woodType).getResource()));
                String logPath = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)log)).m_135815_();
                SawmillingRecipeProvider.panelsRecipe(consumer, woodType, log, 4);
                SawmillingRecipeProvider.panelsSlabRecipe(consumer, woodType, log, 8, null);
                SawmillingRecipeProvider.panelsStairsRecipe(consumer, woodType, log, 4, null);
                SawmillingRecipeProvider.stickRecipe(consumer, woodType, log, 8, null);
                SawmillingRecipeProvider.planksRecipe(consumer, woodType, log, 4, null);
                SawmillingRecipeProvider.slabRecipe(consumer, woodType, log, 8, null);
                SawmillingRecipeProvider.vanillaStickRecipe(consumer, log, 8, null);
                SawmillingRecipeProvider.wallRecipe(consumer, woodType, log, 1);
                SawmillingRecipeProvider.postRecipe(consumer, woodType, log, 2);
                SawmillingRecipeProvider.strippedPostRecipe(consumer, woodType, log, 2);
                SawmillingRecipeProvider.logPileRecipe(consumer, woodType, log, 1);
                if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasStrippedLog((IWoodType)woodType)) {
                    Block strippedLog = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog((IWoodType)woodType).getResource()));
                    SawmillingRecipeProvider.sawmillingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), (ItemLike)strippedLog).m_126132_(String.format("has_%s", logPath), (CriterionTriggerInstance)SawmillingRecipeProvider.m_125977_((ItemLike)log)).m_126140_(consumer, new ResourceLocation("ilikewood", Util.toRegistryName(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)strippedLog)).m_135815_(), "from", logPath, "sawmilling")));
                }
            }
            if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasStrippedLog((IWoodType)woodType)) {
                Block strippedLog = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog((IWoodType)woodType).getResource()));
                SawmillingRecipeProvider.panelsRecipe(consumer, woodType, strippedLog, 4);
                SawmillingRecipeProvider.panelsSlabRecipe(consumer, woodType, strippedLog, 8, null);
                SawmillingRecipeProvider.panelsStairsRecipe(consumer, woodType, strippedLog, 4, null);
                SawmillingRecipeProvider.stickRecipe(consumer, woodType, strippedLog, 8, null);
                SawmillingRecipeProvider.planksRecipe(consumer, woodType, strippedLog, 4, null);
                SawmillingRecipeProvider.slabRecipe(consumer, woodType, strippedLog, 8, null);
                SawmillingRecipeProvider.vanillaStickRecipe(consumer, strippedLog, 8, null);
                SawmillingRecipeProvider.strippedPostRecipe(consumer, woodType, strippedLog, 2);
            }
        });
    }
}

