/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodTypes;
import yamahari.ilikewood.provider.texture.TextureBuilder;
import yamahari.ilikewood.provider.texture.TextureFile;
import yamahari.ilikewood.registry.AbstractILikeWoodObjectRegistry;
import yamahari.ilikewood.registry.objecttype.AbstractWoodenObjectType;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public abstract class AbstractTextureProvider<T, O extends AbstractWoodenObjectType, R extends AbstractILikeWoodObjectRegistry<T, O>>
implements DataProvider {
    public static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    public static final String BLOCK_FOLDER = "block";
    public static final String ENTITY_FOLDER = "entity";
    public static final String ITEM_FOLDER = "item";
    public final Map<ResourceLocation, TextureBuilder> generatedTextures = new HashMap<ResourceLocation, TextureBuilder>();
    private final String root;
    private final O objectType;
    private final R objectRegistry;
    private final Function<ResourceLocation, TextureBuilder> factory;
    private final DataGenerator generator;
    private final ExistingFileHelper helper;
    private final String folder;
    private final boolean runOnce;

    public AbstractTextureProvider(DataGenerator generator, String folder, ExistingFileHelper helper, String root, O objectType, R objectRegistry, boolean runOnce) {
        this.generator = generator;
        this.folder = folder;
        this.helper = helper;
        this.root = root;
        this.objectType = objectType;
        this.factory = location -> new TextureBuilder((ResourceLocation)location, helper);
        this.objectRegistry = objectRegistry;
        this.runOnce = runOnce;
    }

    public AbstractTextureProvider(DataGenerator generator, String folder, ExistingFileHelper helper, String root, O objectType, R objectRegistry) {
        this(generator, folder, helper, root, objectType, objectRegistry, false);
    }

    private Map<Integer, Integer> createColorMap(IWoodType woodType) {
        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
        int[] spruceColors = VanillaWoodTypes.SPRUCE.getColors().colors();
        int[] colors = woodType.getColors().colors();
        for (int i = 0; i < 8; ++i) {
            colorMap.put(spruceColors[i], colors[i]);
        }
        return Collections.unmodifiableMap(colorMap);
    }

    protected Function<NativeImage, NativeImage> createColorMapTransformer(Map<Integer, Integer> colorMap) {
        return image -> {
            NativeImage result = new NativeImage(image.m_84982_(), image.m_85084_(), true);
            result.m_85054_(image);
            for (int y = 0; y < image.m_85084_(); ++y) {
                for (int x = 0; x < image.m_84982_(); ++x) {
                    int rgba = image.m_84985_(x, y);
                    if (!colorMap.containsKey(rgba)) continue;
                    result.m_84988_(x, y, ((Integer)colorMap.get(rgba)).intValue());
                }
            }
            return result;
        };
    }

    protected Function<NativeImage, NativeImage> createColorMapTransformer(IWoodType woodType) {
        return this.createColorMapTransformer(this.createColorMap(woodType));
    }

    protected NativeImage postTransformer(NativeImage image) {
        Preconditions.checkArgument((image.m_84982_() == 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((image.m_85084_() % image.m_84982_() == 0 ? 1 : 0) != 0);
        NativeImage result = new NativeImage(image.m_84982_(), image.m_85084_(), true);
        result.m_85054_(image);
        int di = image.m_85084_() / image.m_84982_();
        for (int i = 0; i < di; ++i) {
            int x;
            int y;
            Rect2i cut = new Rect2i(0, 12, 8, 4);
            NativeImage copy = this.copyRect(image, i, cut);
            Rect2i paste = new Rect2i(8, 0, 8, 4);
            for (y = 0; y < paste.m_110091_(); ++y) {
                for (x = 0; x < paste.m_110090_(); ++x) {
                    result.m_84988_(paste.m_110085_() + x, i * 16 + paste.m_110086_() + y, copy.m_84985_(copy.m_84982_() - x - 1, copy.m_85084_() - y - 1));
                }
            }
            cut = new Rect2i(0, 0, 16, 4);
            copy = this.copyRect(result, i, cut);
            for (y = 0; y < cut.m_110091_(); ++y) {
                for (x = 0; x < cut.m_110090_(); ++x) {
                    int color = copy.m_84985_(x, y);
                    result.m_84988_(15 - y, i * 16 + x, color);
                    result.m_84988_(15 - x, i * 16 + 15 - y, color);
                    result.m_84988_(y, i * 16 + 15 - x, color);
                }
            }
            for (y = 4; y < 12; ++y) {
                for (x = 4; x < 12; ++x) {
                    result.m_84988_(x, i * 16 + y, 0);
                }
            }
            for (y = 0; y < 4; ++y) {
                for (x = 0; x < 4; ++x) {
                    result.m_84988_(x, i * 16 + y, 0);
                    result.m_84988_(12 + x, i * 16 + y, 0);
                    result.m_84988_(12 + x, i * 16 + 12 + y, 0);
                    result.m_84988_(x, 12 + i * 16 + y, 0);
                }
            }
        }
        return result;
    }

    private NativeImage copyRect(NativeImage image, int i, Rect2i cut) {
        NativeImage copy = new NativeImage(cut.m_110090_(), cut.m_110091_(), true);
        for (int y = 0; y < cut.m_110091_(); ++y) {
            for (int x = 0; x < cut.m_110090_(); ++x) {
                copy.m_84988_(x, y, image.m_84985_(cut.m_110085_() + x, i * 16 + cut.m_110086_() + y));
            }
        }
        return copy;
    }

    public TextureBuilder getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = this.extendWithFolder(path.contains(":") ? this.mcLoc(path) : this.modLoc(path));
        this.helper.trackGenerated(outputLoc, (ExistingFileHelper.IResourceType)TEXTURE);
        return this.generatedTextures.computeIfAbsent(outputLoc, this.factory);
    }

    private ResourceLocation extendWithFolder(ResourceLocation rl) {
        if (rl.m_135815_().contains("/")) {
            return rl;
        }
        return new ResourceLocation(rl.m_135827_(), this.folder + "/" + rl.m_135815_());
    }

    public TextureBuilder withExistingParent(String name, String parent) {
        return this.withExistingParent(name, this.mcLoc(parent));
    }

    public TextureBuilder withExistingParent(String name, ResourceLocation parent) {
        return this.getBuilder(name).parent(this.getExistingFile(parent));
    }

    public TextureFile.ExistingTextureFile getExistingFile(ResourceLocation path) {
        TextureFile.ExistingTextureFile file = new TextureFile.ExistingTextureFile(this.extendWithFolder(path), this.helper);
        file.assertExistence();
        return file;
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation("ilikewood", name);
    }

    public ResourceLocation mcLoc(String name) {
        return new ResourceLocation(name);
    }

    public void m_213708_(@Nonnull CachedOutput cache) throws IOException {
        if (this.runOnce) {
            this.createTexture(null);
        } else {
            ((AbstractILikeWoodObjectRegistry)this.objectRegistry).getObjects(this.objectType).forEach(this::createTexture);
        }
        for (TextureBuilder builder : this.generatedTextures.values()) {
            builder.build(this.generator.m_123916_().resolve(this.root), cache);
        }
    }

    @Nonnull
    public String m_6055_() {
        return String.format("%s - textures - %s", "ilikewood", ((AbstractWoodenObjectType)this.objectType).getName());
    }

    protected abstract void createTexture(T var1);
}

