/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.texture.AbstractTextureProvider;
import yamahari.ilikewood.provider.texture.TextureFile;

public class TextureBuilder
extends TextureFile {
    protected final ExistingFileHelper helper;
    private TextureFile parent;
    private Function<NativeImage, NativeImage> transformer;
    private boolean animated;
    private boolean interpolate;
    private int frameTime;

    public TextureBuilder(ResourceLocation outputLocation, ExistingFileHelper helper) {
        super(outputLocation);
        this.helper = helper;
        this.animated = false;
        this.interpolate = false;
        this.frameTime = 1;
    }

    public TextureBuilder parent(TextureFile parent) {
        Preconditions.checkNotNull((Object)parent, (Object)"Parent must not be null");
        parent.assertExistence();
        this.parent = parent;
        return this;
    }

    public TextureBuilder transform(Function<NativeImage, NativeImage> transformer) {
        this.transformer = transformer;
        return this;
    }

    public TextureBuilder animate(boolean interpolate, int frameTime) {
        this.animated = true;
        this.interpolate = interpolate;
        this.frameTime = frameTime;
        return this;
    }

    public void build(@Nonnull Path rootPath, @Nonnull CachedOutput cache) throws IOException {
        try {
            Resource parentResource = this.helper.getResource(this.parent.getLocation(), PackType.CLIENT_RESOURCES, AbstractTextureProvider.TEXTURE.getSuffix(), AbstractTextureProvider.TEXTURE.getPrefix());
            NativeImage parentImage = NativeImage.m_85058_((InputStream)parentResource.m_215507_());
            NativeImage image = this.transformer.apply(parentImage);
            Path pngPath = rootPath.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), this.getLocation().m_135827_(), AbstractTextureProvider.TEXTURE.getPrefix(), this.getLocation().m_135815_() + AbstractTextureProvider.TEXTURE.getSuffix()));
            if (this.animated) {
                Path mcMetaPath = rootPath.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), this.getLocation().m_135827_(), AbstractTextureProvider.TEXTURE.getPrefix(), this.getLocation().m_135815_() + AbstractTextureProvider.TEXTURE.getSuffix()) + ".mcmeta");
                JsonObject jsonObject = new JsonObject();
                JsonObject animation = new JsonObject();
                animation.addProperty("interpolate", Boolean.valueOf(this.interpolate));
                animation.addProperty("frametime", (Number)this.frameTime);
                jsonObject.add("animation", (JsonElement)animation);
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)jsonObject, (Path)mcMetaPath);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
            hashingOutputStream.write(image.m_85121_());
            cache.m_213871_(pngPath, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
        }
        catch (IOException e) {
            ILikeWood.LOGGER.error("Couldn't create data for {}", (Object)this.getLocation(), (Object)e);
            throw e;
        }
    }

    @Override
    protected boolean exists() {
        return true;
    }
}

