/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture;

import com.google.common.base.Preconditions;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.provider.texture.AbstractTextureProvider;

public abstract class TextureFile {
    private final ResourceLocation location;

    protected TextureFile(ResourceLocation location) {
        this.location = location;
    }

    protected abstract boolean exists();

    public ResourceLocation getLocation() {
        this.assertExistence();
        return this.location;
    }

    public void assertExistence() {
        Preconditions.checkState((boolean)this.exists(), (String)"Texture at %s does not exist", (Object)this.location);
    }

    public ResourceLocation getUncheckedLocation() {
        return this.location;
    }

    public static class ExistingTextureFile
    extends TextureFile {
        private final ExistingFileHelper existingHelper;

        public ExistingTextureFile(ResourceLocation location, ExistingFileHelper existingHelper) {
            super(location);
            this.existingHelper = existingHelper;
        }

        @Override
        protected boolean exists() {
            return this.existingHelper.exists(this.getUncheckedLocation(), (ExistingFileHelper.IResourceType)AbstractTextureProvider.TEXTURE);
        }
    }

    public static class UncheckedTextureFile
    extends TextureFile {
        public UncheckedTextureFile(String location) {
            this(new ResourceLocation(location));
        }

        public UncheckedTextureFile(ResourceLocation location) {
            super(location);
        }

        @Override
        protected boolean exists() {
            return true;
        }
    }
}

