/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture.block;

import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.provider.texture.block.AbstractBlockTextureProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.util.Util;

public class CampfireFireTextureProvider
extends AbstractBlockTextureProvider {
    public CampfireFireTextureProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "block", helper, "campfires", WoodenBlockType.CAMPFIRE, true);
    }

    @Override
    protected void createTexture(Block block) {
        int[] fireColors = new int[]{11616000, 13200387, 14656027, 15318329, 15715670, 16378795, 0xFEFEFB};
        for (DyeColor dyeColor : DyeColor.values()) {
            Map<Integer, Integer> fireColorMap = Util.createShadeColorMap(dyeColor, fireColors);
            this.withExistingParent(Util.toPath("block", WoodenBlockType.CAMPFIRE.getName(), "fire", dyeColor.m_41065_()), this.mcLoc(Util.toPath("block", "campfire_fire"))).transform(this.createColorMapTransformer(fireColorMap)).animate(false, 2);
            this.withExistingParent(Util.toPath("block", WoodenBlockType.CAMPFIRE.getName(), "log_lit", dyeColor.m_41065_()), this.modLoc(Util.toPath("block", WoodenBlockType.CAMPFIRE.getName(), "log_lit", "template"))).transform(this.createColorMapTransformer(fireColorMap)).animate(true, 20);
        }
    }
}

