/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture.block;

import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.provider.texture.block.AbstractBlockTextureProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.util.Util;

public class ColoredCampfireSmokeParticleTextureProvider
extends AbstractBlockTextureProvider {
    public ColoredCampfireSmokeParticleTextureProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "particle", helper, "campfires", WoodenBlockType.CAMPFIRE, true);
    }

    @Override
    protected void createTexture(Block block) {
        int[] smokeColors = new int[]{0x6B6661, 7235939, 7301733, 7433575, 7630698, 7827821, 7893870, 8025456, 8156784, 0x7D7773, 8288628, 8354162, 8485748, 8486006, 8683384, 8880506, 9077373, 9143422, 9275008, 0x8E8881};
        int[] lavaColors = new int[]{0xFF0000, 16738816, 16766976, 16774598};
        for (DyeColor dyeColor : DyeColor.values()) {
            Map<Integer, Integer> smokeColorMap = Util.createShadeColorMap(dyeColor, smokeColors);
            Map<Integer, Integer> lavaColorMap = Util.createShadeColorMap(dyeColor, lavaColors);
            for (int i = 0; i < 12; ++i) {
                this.withExistingParent(Util.toPath("particle", WoodenBlockType.CAMPFIRE.getName(), "big_smoke", dyeColor.m_41065_(), Integer.toString(i)), this.mcLoc(Util.toPath("particle", String.format("big_smoke_%d", i)))).transform(this.createColorMapTransformer(smokeColorMap));
            }
            this.withExistingParent(Util.toPath("particle", WoodenBlockType.CAMPFIRE.getName(), "lava", dyeColor.m_41065_()), this.mcLoc(Util.toPath("particle", "lava"))).transform(this.createColorMapTransformer(lavaColorMap));
        }
    }
}

