/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture.block;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.provider.texture.TextureBuilder;
import yamahari.ilikewood.provider.texture.block.AbstractBlockTextureProvider;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class PostTextureProvider
extends AbstractBlockTextureProvider {
    public PostTextureProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "block", helper, "posts", WoodenBlockType.POST);
    }

    @Override
    protected void createTexture(Block block) {
        IWoodType woodType = ((IWooden)block).getWoodType();
        String path = Util.toPath("block", WoodenBlockType.POST.getName());
        IWoodenLogResource logResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getLog(woodType);
        TextureBuilder builder = this.withExistingParent(Util.toPath(path, woodType.getModId(), woodType.getName()), logResource.getSideTexture()).transform(x$0 -> this.postTransformer((NativeImage)x$0));
        IWoodenLogResource.SideTextureProperties properties = logResource.getSideTextureProperties();
        if (properties.animated()) {
            builder.animate(properties.interpolate(), properties.frameTime());
        }
        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasStrippedLog(woodType)) {
            IWoodenStrippedLogResource strippedLogResource = ILikeWood.WOODEN_RESOURCE_REGISTRY.getStrippedLog(woodType);
            this.withExistingParent(Util.toPath(path, "stripped", woodType.getModId(), woodType.getName()), strippedLogResource.getSideTexture()).transform(x$0 -> this.postTransformer((NativeImage)x$0));
        }
    }
}

