/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture.item;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.provider.texture.item.AbstractItemTextureProvider;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class CrossbowTextureProvider
extends AbstractItemTextureProvider {
    public CrossbowTextureProvider(DataGenerator generator, ExistingFileHelper helper) {
        super(generator, "item", helper, "crossbows", WoodenItemType.CROSSBOW);
    }

    @Override
    protected void createTexture(Item item) {
        IWoodType woodType = ((IWooden)item).getWoodType();
        String path = Util.toPath("item", WoodenItemType.CROSSBOW.getName());
        Function<NativeImage, NativeImage> colorMapTransformer = this.createColorMapTransformer(woodType);
        this.withExistingParent(Util.toPath(path, woodType.getModId(), "arrow", woodType.getName()), this.modLoc(Util.toPath(path, "arrow", "template"))).transform(colorMapTransformer);
        this.withExistingParent(Util.toPath(path, woodType.getModId(), "firework", woodType.getName()), this.modLoc(Util.toPath(path, "firework", "template"))).transform(colorMapTransformer);
        for (int i = 0; i < 3; ++i) {
            this.withExistingParent(Util.toPath(path, woodType.getModId(), "pulling", Integer.toString(i), woodType.getName()), this.modLoc(Util.toPath(path, "pulling", Integer.toString(i), "template"))).transform(colorMapTransformer);
        }
        this.withExistingParent(Util.toPath(path, woodType.getModId(), "standby", woodType.getName()), this.modLoc(Util.toPath(path, "standby", "template"))).transform(colorMapTransformer);
    }
}

