/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.provider.texture.item.tiered;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import yamahari.ilikewood.provider.texture.item.AbstractItemTextureProvider;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;
import yamahari.ilikewood.util.Util;

public final class ToolTextureProvider
extends AbstractItemTextureProvider {
    private final WoodenTieredItemType tieredItemType;

    public ToolTextureProvider(DataGenerator generator, ExistingFileHelper helper, WoodenTieredItemType tieredItemType) {
        super(generator, "item", helper, tieredItemType.getNamePlural(), WoodenItemType.STICK);
        this.tieredItemType = tieredItemType;
    }

    @Override
    protected void createTexture(Item item) {
        IWoodType woodType = ((IWooden)item).getWoodType();
        String path = Util.toPath("item", this.tieredItemType.getName());
        Function<NativeImage, NativeImage> colorMapTransformer = this.createColorMapTransformer(woodType);
        this.withExistingParent(Util.toPath(path, woodType.getModId(), "wooden", woodType.getName()), this.modLoc(Util.toPath(path, "wooden", "template"))).transform(colorMapTransformer);
    }

    @Override
    @Nonnull
    public String m_6055_() {
        return String.format("%s - textures - %s", "ilikewood", this.tieredItemType.getName());
    }
}

