/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import yamahari.ilikewood.registry.IWoodenObjectRegistry;
import yamahari.ilikewood.registry.objecttype.AbstractWoodenObjectType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public abstract class AbstractILikeWoodObjectRegistry<T, O extends AbstractWoodenObjectType>
implements IWoodenObjectRegistry<T, O> {
    protected final DeferredRegister<T> registry;
    protected final Map<O, Map<IWoodType, RegistryObject<T>>> registryObjects;

    protected AbstractILikeWoodObjectRegistry(IForgeRegistry<T> registry) {
        this.registry = DeferredRegister.create(registry, (String)"ilikewood");
        this.registryObjects = new HashMap<O, Map<IWoodType, RegistryObject<T>>>();
    }

    public final void register(IEventBus eventBus) {
        this.register();
        this.registry.register(eventBus);
    }

    protected abstract void register();

    @Override
    public final RegistryObject<T> getRegistryObject(IWoodType woodType, O objectType) throws IllegalArgumentException {
        Map<IWoodType, RegistryObject<T>> objects = this.registryObjects.get(objectType);
        if (objects != null) {
            RegistryObject<T> registryObject;
            RegistryObject<T> registryObject2 = registryObject = ((AbstractWoodenObjectType)objectType).variesByWoodType() ? objects.get(woodType) : objects.get(Util.DUMMY_WOOD_TYPE);
            if (registryObject != null) {
                return registryObject;
            }
            throw new IllegalArgumentException(String.format("ObjectType[%s] has no registered blocks of IWoodType[%s]", ((AbstractWoodenObjectType)objectType).getName(), woodType.getName()));
        }
        throw new IllegalArgumentException(String.format("ObjectType[%s] has no registered blocks.", ((AbstractWoodenObjectType)objectType).getName()));
    }

    @Override
    public final Stream<RegistryObject<T>> getRegistryObjects(Stream<O> objectTypes) {
        return objectTypes.flatMap(this::getRegistryObjects);
    }

    @Override
    public final T getObject(IWoodType woodType, O objectType) throws IllegalArgumentException {
        return (T)this.getRegistryObject(woodType, objectType).get();
    }

    @Override
    public final Stream<T> getObjects(O objectType) {
        return this.getRegistryObjects(objectType).map(RegistryObject::get);
    }

    @Override
    public final Stream<T> getObjects(Stream<O> objectTypes) {
        return objectTypes.flatMap(this::getObjects);
    }
}

