/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.item.WoodenBedItem;
import yamahari.ilikewood.item.WoodenBlockItem;
import yamahari.ilikewood.item.WoodenChestBlockItem;
import yamahari.ilikewood.item.WoodenScaffoldingItem;
import yamahari.ilikewood.item.WoodenWallOrFloorItem;
import yamahari.ilikewood.registry.AbstractILikeWoodObjectRegistry;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class ILikeWoodBlockItemRegistry
extends AbstractILikeWoodObjectRegistry<Item, WoodenBlockType> {
    public ILikeWoodBlockItemRegistry() {
        super(ForgeRegistries.ITEMS);
    }

    @Override
    protected void register() {
        this.registerBlockItems(WoodenBlockType.PANELS, this::registerPanelsBlockItem);
        this.registerBlockItems(WoodenBlockType.PANELS_STAIRS, this::registerPanelsStairsBlockItem);
        this.registerBlockItems(WoodenBlockType.PANELS_SLAB, this::registerPanelsSlabBlockItem);
        this.registerBlockItems(WoodenBlockType.BOOKSHELF, this::registerBookshelfBlockItem);
        this.registerBlockItems(WoodenBlockType.BARREL, this::registerBarrelBlockItem);
        this.registerBlockItems(WoodenBlockType.WALL, this::registerWallBlockItem);
        this.registerBlockItems(WoodenBlockType.LADDER, this::registerLadderBlockItem);
        this.registerBlockItems(WoodenBlockType.CRAFTING_TABLE, this::registerCraftingTableBlockItem);
        this.registerBlockItems(WoodenBlockType.POST, this::registerPostBlockItem);
        this.registerBlockItems(WoodenBlockType.STRIPPED_POST, this::registerStrippedPostBlockItem);
        this.registerBlockItems(WoodenBlockType.SAWMILL, this::registerSawmillBlockItem);
        this.registerBlockItems(WoodenBlockType.COMPOSTER, this::registerComposterBlockItem);
        this.registerBlockItems(WoodenBlockType.LECTERN, this::registerLecternBlockItem);
        this.registerBlockItems(WoodenBlockType.CHEST, this::registerChestBlockItem);
        this.registerBlockItems(WoodenBlockType.TORCH, this::registerTorchBlockItem);
        this.registerBlockItems(WoodenBlockType.SOUL_TORCH, this::registerSoulTorchBlockItem);
        this.registerBlockItems(WoodenBlockType.SCAFFOLDING, this::registerScaffoldingBlockItem);
        this.registerBlockItems(WoodenBlockType.CHAIR, this::registerChairBlockItem);
        this.registerBlockItems(WoodenBlockType.TABLE, this::registerTableBlockItem);
        this.registerBlockItems(WoodenBlockType.STOOL, this::registerStoolBlockItem);
        this.registerBlockItems(WoodenBlockType.SINGLE_DRESSER, this::registerSingleDresserBlockItem);
        this.registerBlockItems(WoodenBlockType.LOG_PILE, this::registerLogPileBlockItem);
        this.registerBlockItems(WoodenBlockType.CAMPFIRE, this::registerCampfireBlockItem);
        this.registerBlockItems(WoodenBlockType.SOUL_CAMPFIRE, this::registerSoulCampfireBlockItem);
        WoodenBlockType.getBeds().forEach(bedBlockType -> this.registerBlockItems((WoodenBlockType)bedBlockType, woodType -> this.registerBedBlockItem((IWoodType)woodType, (WoodenBlockType)bedBlockType)));
        this.registerBlockItems(WoodenBlockType.CRATE, this::registerCrateBlockItem);
    }

    @Override
    public Stream<RegistryObject<Item>> getRegistryObjects(WoodenBlockType blockType) {
        return ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getBlockTypes().contains(blockType)).map(woodType -> this.getRegistryObject((IWoodType)woodType, blockType));
    }

    private void registerBlockItems(WoodenBlockType blockType, Function<IWoodType, RegistryObject<Item>> function) {
        if (blockType.isEnabled()) {
            HashMap blockItems = new HashMap();
            ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getBlockTypes().contains(blockType)).forEach(woodType -> blockItems.put(woodType, (RegistryObject)function.apply((IWoodType)woodType)));
            this.registryObjects.put(blockType, Collections.unmodifiableMap(blockItems));
        }
    }

    private RegistryObject<Item> registerBlockItem(IWoodType woodType, WoodenBlockType blockType, Item.Properties properties) {
        RegistryObject block = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, blockType);
        return this.registry.register(block.getId().m_135815_(), () -> new WoodenBlockItem(blockType, (Block)block.get(), properties));
    }

    private RegistryObject<Item> registerBlockItem(IWoodType woodType, WoodenBlockType blockType, CreativeModeTab itemGroup) {
        return this.registerBlockItem(woodType, blockType, new Item.Properties().m_41491_(itemGroup));
    }

    private RegistryObject<Item> registerBuildingBlockItem(IWoodType woodType, WoodenBlockType blockType) {
        return this.registerBlockItem(woodType, blockType, CreativeModeTab.f_40749_);
    }

    private RegistryObject<Item> registerDecorationBlockItem(IWoodType woodType, WoodenBlockType blockType) {
        return this.registerBlockItem(woodType, blockType, CreativeModeTab.f_40750_);
    }

    private RegistryObject<Item> registerMiscBlockItem(IWoodType woodType, WoodenBlockType blockType) {
        return this.registerBlockItem(woodType, blockType, CreativeModeTab.f_40753_);
    }

    private RegistryObject<Item> registerRedstoneBlockItem(IWoodType woodType, WoodenBlockType blockType) {
        return this.registerBlockItem(woodType, blockType, CreativeModeTab.f_40751_);
    }

    private RegistryObject<Item> registerPanelsBlockItem(IWoodType woodType) {
        return this.registerBuildingBlockItem(woodType, WoodenBlockType.PANELS);
    }

    private RegistryObject<Item> registerPanelsStairsBlockItem(IWoodType woodType) {
        return this.registerBuildingBlockItem(woodType, WoodenBlockType.PANELS_STAIRS);
    }

    private RegistryObject<Item> registerPanelsSlabBlockItem(IWoodType woodType) {
        return this.registerBuildingBlockItem(woodType, WoodenBlockType.PANELS_SLAB);
    }

    private RegistryObject<Item> registerBookshelfBlockItem(IWoodType woodType) {
        return this.registerBuildingBlockItem(woodType, WoodenBlockType.BOOKSHELF);
    }

    private RegistryObject<Item> registerBarrelBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.BARREL);
    }

    private RegistryObject<Item> registerWallBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.WALL);
    }

    private RegistryObject<Item> registerLadderBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.LADDER);
    }

    private RegistryObject<Item> registerScaffoldingBlockItem(IWoodType woodType) {
        RegistryObject scaffoldingBlock = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, WoodenBlockType.SCAFFOLDING);
        return this.registry.register(scaffoldingBlock.getId().m_135815_(), () -> new WoodenScaffoldingItem((Block)scaffoldingBlock.get()));
    }

    private RegistryObject<Item> registerCraftingTableBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.CRAFTING_TABLE);
    }

    private RegistryObject<Item> registerPostBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.POST);
    }

    private RegistryObject<Item> registerStrippedPostBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.STRIPPED_POST);
    }

    private RegistryObject<Item> registerSawmillBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.SAWMILL);
    }

    private RegistryObject<Item> registerComposterBlockItem(IWoodType woodType) {
        return this.registerMiscBlockItem(woodType, WoodenBlockType.COMPOSTER);
    }

    private RegistryObject<Item> registerLecternBlockItem(IWoodType woodType) {
        return this.registerRedstoneBlockItem(woodType, WoodenBlockType.LECTERN);
    }

    private RegistryObject<Item> registerChestBlockItem(IWoodType woodType) {
        RegistryObject chest = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, WoodenBlockType.CHEST);
        return this.registry.register(chest.getId().m_135815_(), () -> new WoodenChestBlockItem((Block)chest.get()));
    }

    private RegistryObject<Item> registerBedBlockItem(IWoodType woodType, WoodenBlockType bedBlockType) {
        RegistryObject bed = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, bedBlockType);
        return this.registry.register(bed.getId().m_135815_(), () -> new WoodenBedItem(bedBlockType, (Block)bed.get()));
    }

    private RegistryObject<Item> registerTorchBlockItem(IWoodType woodType, WoodenBlockType torchBlockType, WoodenBlockType wallTorchBlockType) {
        RegistryObject torch = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, torchBlockType);
        RegistryObject wallTorch = ILikeWood.BLOCK_REGISTRY.getRegistryObject(woodType, wallTorchBlockType);
        return this.registry.register(torch.getId().m_135815_(), () -> new WoodenWallOrFloorItem(torchBlockType, (Block)torch.get(), (Block)wallTorch.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    }

    private RegistryObject<Item> registerTorchBlockItem(IWoodType woodType) {
        return this.registerTorchBlockItem(woodType, WoodenBlockType.TORCH, WoodenBlockType.WALL_TORCH);
    }

    private RegistryObject<Item> registerSoulTorchBlockItem(IWoodType woodType) {
        return this.registerTorchBlockItem(woodType, WoodenBlockType.SOUL_TORCH, WoodenBlockType.WALL_SOUL_TORCH);
    }

    private RegistryObject<Item> registerChairBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.CHAIR);
    }

    private RegistryObject<Item> registerTableBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.TABLE);
    }

    private RegistryObject<Item> registerStoolBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.STOOL);
    }

    private RegistryObject<Item> registerSingleDresserBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.SINGLE_DRESSER);
    }

    private RegistryObject<Item> registerLogPileBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.LOG_PILE);
    }

    private RegistryObject<Item> registerCampfireBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.CAMPFIRE);
    }

    private RegistryObject<Item> registerSoulCampfireBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.SOUL_CAMPFIRE);
    }

    private RegistryObject<Item> registerCrateBlockItem(IWoodType woodType) {
        return this.registerDecorationBlockItem(woodType, WoodenBlockType.CRATE);
    }
}

