/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.config.ILikeWoodConfig;
import yamahari.ilikewood.entity.WoodenChairEntity;
import yamahari.ilikewood.entity.WoodenItemFrameEntity;
import yamahari.ilikewood.entity.WoodenPaintingEntity;
import yamahari.ilikewood.registry.AbstractILikeWoodObjectRegistry;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class ILikeWoodEntityTypeRegistry
extends AbstractILikeWoodObjectRegistry<EntityType<?>, WoodenEntityType> {
    public ILikeWoodEntityTypeRegistry() {
        super(ForgeRegistries.ENTITY_TYPES);
    }

    private void registerChairEntityTypes() {
        this.registryObjects.put(WoodenEntityType.CHAIR, Collections.singletonMap(Util.DUMMY_WOOD_TYPE, this.registerChairEntityType()));
    }

    private void registerItemFrameEntityTypes() {
        HashMap entityTypes = new HashMap();
        ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getItemTypes().contains(WoodenItemType.ITEM_FRAME)).forEach(woodType -> entityTypes.put(woodType, this.registerItemFrameEntityType((IWoodType)woodType)));
        this.registryObjects.put(WoodenEntityType.ITEM_FRAME, Collections.unmodifiableMap(entityTypes));
    }

    private void registerPaintingEntityTypes() {
        this.registryObjects.put(WoodenEntityType.PAINTING, Collections.singletonMap(Util.DUMMY_WOOD_TYPE, this.registerPaintingEntityType()));
    }

    private RegistryObject<EntityType<?>> registerItemFrameEntityType(IWoodType woodType) {
        String name = woodType.getModId().equals("ilikewood") ? Util.toRegistryName(woodType.getName(), WoodenEntityType.ITEM_FRAME.getName()) : Util.toRegistryName(woodType.getModId(), woodType.getName(), WoodenEntityType.ITEM_FRAME.getName());
        return this.registry.register(name, () -> EntityType.Builder.m_20704_((entityType, world) -> new WoodenItemFrameEntity(woodType, (EntityType<? extends ItemFrame>)entityType, world), (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(10).m_20717_(Integer.MAX_VALUE).m_20712_(name));
    }

    private RegistryObject<EntityType<?>> registerChairEntityType() {
        String name = WoodenEntityType.CHAIR.getName();
        return this.registry.register(name, () -> EntityType.Builder.m_20704_(WoodenChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.0f, 0.0f).m_20712_(name));
    }

    private RegistryObject<EntityType<?>> registerPaintingEntityType() {
        String name = WoodenEntityType.PAINTING.getName();
        return this.registry.register(name, () -> EntityType.Builder.m_20704_(WoodenPaintingEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(10).m_20717_(Integer.MAX_VALUE).m_20712_(name));
    }

    @Override
    protected void register() {
        if (ILikeWoodConfig.ITEM_FRAMES_CONFIG.isEnabled()) {
            this.registerItemFrameEntityTypes();
        }
        if (ILikeWoodConfig.CHAIRS_CONFIG.isEnabled() || ILikeWoodConfig.STOOLS_CONFIG.isEnabled()) {
            this.registerChairEntityTypes();
        }
        if (ILikeWoodConfig.PAINTING_CONFIG.isEnabled()) {
            this.registerPaintingEntityTypes();
        }
    }

    @Override
    public Stream<RegistryObject<EntityType<?>>> getRegistryObjects(WoodenEntityType objectType) {
        return ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getEntityTypes().contains(objectType)).map(woodType -> this.getRegistryObject((IWoodType)woodType, objectType)).distinct();
    }
}

