/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.item.WoodenBowItem;
import yamahari.ilikewood.item.WoodenCrossbowItem;
import yamahari.ilikewood.item.WoodenFishingRodItem;
import yamahari.ilikewood.item.WoodenItem;
import yamahari.ilikewood.item.WoodenItemFrameItem;
import yamahari.ilikewood.item.WoodenPaintingItem;
import yamahari.ilikewood.registry.AbstractILikeWoodObjectRegistry;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class ILikeWoodItemRegistry
extends AbstractILikeWoodObjectRegistry<Item, WoodenItemType> {
    public ILikeWoodItemRegistry() {
        super(ForgeRegistries.ITEMS);
    }

    @Override
    protected void register() {
        this.registerItems(WoodenItemType.STICK, this::registerStickItem);
        this.registerItems(WoodenItemType.BOW, this::registerBowItem);
        this.registerItems(WoodenItemType.CROSSBOW, this::registerCrossbowItem);
        this.registerItems(WoodenItemType.ITEM_FRAME, this::registerItemFrameItem);
        this.registerItems(WoodenItemType.FISHING_ROD, this::registerFishingPoleItem);
        this.registerItems(WoodenItemType.PAINTING, this::registerPaintingItem);
    }

    @Override
    public Stream<RegistryObject<Item>> getRegistryObjects(WoodenItemType objectType) {
        return ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getItemTypes().contains(objectType)).map(woodType -> this.getRegistryObject((IWoodType)woodType, objectType));
    }

    private void registerItems(WoodenItemType itemType, Function<IWoodType, RegistryObject<Item>> function) {
        if (itemType.isEnabled()) {
            HashMap items = new HashMap();
            ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getItemTypes().contains(itemType)).forEach(woodType -> items.put(woodType, (RegistryObject)function.apply((IWoodType)woodType)));
            this.registryObjects.put(itemType, Collections.unmodifiableMap(items));
        }
    }

    private RegistryObject<Item> register(IWoodType woodType, WoodenItemType itemType, Supplier<? extends Item> supplier) {
        String name = woodType.getModId().equals("ilikewood") ? Util.toRegistryName(woodType.getName(), itemType.getName()) : Util.toRegistryName(woodType.getModId(), woodType.getName(), itemType.getName());
        return this.registry.register(name, supplier);
    }

    private RegistryObject<Item> registerStickItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.STICK, () -> new WoodenItem(woodType, WoodenItemType.STICK, new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    }

    private RegistryObject<Item> registerBowItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.BOW, () -> new WoodenBowItem(woodType));
    }

    private RegistryObject<Item> registerCrossbowItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.CROSSBOW, () -> new WoodenCrossbowItem(woodType));
    }

    private RegistryObject<Item> registerItemFrameItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.ITEM_FRAME, () -> new WoodenItemFrameItem(woodType));
    }

    private RegistryObject<Item> registerFishingPoleItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.FISHING_ROD, () -> new WoodenFishingRodItem(woodType));
    }

    private RegistryObject<Item> registerPaintingItem(IWoodType woodType) {
        return this.register(woodType, WoodenItemType.PAINTING, () -> new WoodenPaintingItem(woodType));
    }
}

