/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.item.tiered.WoodenHoeItem;
import yamahari.ilikewood.item.tiered.WoodenSwordItem;
import yamahari.ilikewood.item.tiered.tool.WoodenAxeItem;
import yamahari.ilikewood.item.tiered.tool.WoodenPickAxeItem;
import yamahari.ilikewood.item.tiered.tool.WoodenShovelItem;
import yamahari.ilikewood.registry.IWoodenTieredItemRegistry;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTier;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class ILikeWoodTieredItemRegistry
implements IWoodenTieredItemRegistry {
    private final DeferredRegister<Item> registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ilikewood");
    private final Map<WoodenTieredItemType, Map<IWoodType, Map<IWoodenItemTier, RegistryObject<Item>>>> tieredRegistryObjects = new HashMap<WoodenTieredItemType, Map<IWoodType, Map<IWoodenItemTier, RegistryObject<Item>>>>();

    @Override
    public RegistryObject<Item> getRegistryObject(IWoodenItemTier woodenItemTier, IWoodType woodType, WoodenTieredItemType tieredItemType) throws IllegalArgumentException {
        Map<IWoodType, Map<IWoodenItemTier, RegistryObject<Item>>> objects = this.tieredRegistryObjects.get(tieredItemType);
        if (objects != null) {
            Map<IWoodenItemTier, RegistryObject<Item>> tieredObjects = objects.get(woodType);
            if (tieredObjects != null) {
                RegistryObject<Item> tieredObject = tieredObjects.get(woodenItemTier);
                if (tieredObject != null) {
                    return tieredObject;
                }
                throw new IllegalArgumentException("");
            }
            throw new IllegalArgumentException("");
        }
        throw new IllegalArgumentException("");
    }

    @Override
    public Stream<RegistryObject<Item>> getRegistryObjects(IWoodType woodType, WoodenTieredItemType tieredItemType) throws IllegalArgumentException {
        return ILikeWood.WOODEN_ITEM_TIER_REGISTRY.getWoodenItemTiers().filter(itemTier -> !itemTier.isWood() || itemTier.getWoodType().equals(woodType)).map(woodenItemTier -> this.getRegistryObject((IWoodenItemTier)woodenItemTier, woodType, tieredItemType));
    }

    @Override
    public Stream<RegistryObject<Item>> getRegistryObjects(WoodenTieredItemType tieredItemType) {
        return ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getTieredItemTypes().contains(tieredItemType)).flatMap(woodType -> this.getRegistryObjects((IWoodType)woodType, tieredItemType));
    }

    @Override
    public Item getObject(IWoodenItemTier woodenItemTier, IWoodType woodType, WoodenTieredItemType tieredItemType) throws IllegalArgumentException {
        return (Item)this.getRegistryObject(woodenItemTier, woodType, tieredItemType).get();
    }

    @Override
    public Stream<Item> getObjects(IWoodType woodType, WoodenTieredItemType tieredItemType) throws IllegalArgumentException {
        return this.getRegistryObjects(woodType, tieredItemType).map(RegistryObject::get);
    }

    @Override
    public Stream<Item> getObjects(WoodenTieredItemType tieredItemType) {
        return this.getRegistryObjects(tieredItemType).map(RegistryObject::get);
    }

    public void register(IEventBus eventBus) {
        this.registerTieredItems(WoodenTieredItemType.AXE, this::registerAxeItem);
        this.registerTieredItems(WoodenTieredItemType.HOE, this::registerHoeItem);
        this.registerTieredItems(WoodenTieredItemType.PICKAXE, this::registerPickaxeItem);
        this.registerTieredItems(WoodenTieredItemType.SHOVEL, this::registerShovelItem);
        this.registerTieredItems(WoodenTieredItemType.SWORD, this::registerSwordItem);
        this.registry.register(eventBus);
    }

    private void registerTieredItems(WoodenTieredItemType tieredItemType, BiFunction<IWoodenItemTier, IWoodType, RegistryObject<Item>> function) {
        if (tieredItemType.isEnabled()) {
            HashMap tieredRegistryObjects = new HashMap();
            ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getTieredItemTypes().contains(tieredItemType)).forEach(woodType -> {
                HashMap registryObjects = new HashMap();
                ILikeWood.WOODEN_ITEM_TIER_REGISTRY.getWoodenItemTiers().filter(itemTier -> !itemTier.isWood() || itemTier.getWoodType().equals(woodType)).forEach(itemTier -> registryObjects.put(itemTier, (RegistryObject)function.apply((IWoodenItemTier)itemTier, (IWoodType)woodType)));
                tieredRegistryObjects.put(woodType, registryObjects);
            });
            this.tieredRegistryObjects.put(tieredItemType, Collections.unmodifiableMap(tieredRegistryObjects));
        }
    }

    private RegistryObject<Item> register(IWoodenItemTier itemTier, IWoodType woodType, WoodenTieredItemType tieredItemType, Supplier<? extends Item> supplier) {
        String name = woodType.getModId().equals("ilikewood") ? Util.toRegistryName((String)(itemTier.isWood() ? "" : itemTier.getName() + "_") + woodType.getName(), tieredItemType.getName()) : Util.toRegistryName(woodType.getModId(), (String)(itemTier.isWood() ? "" : itemTier.getName() + "_") + woodType.getName(), tieredItemType.getName());
        return this.registry.register(name, supplier);
    }

    private RegistryObject<Item> registerHoeItem(IWoodenItemTier itemTier, IWoodType woodType) {
        return this.register(itemTier, woodType, WoodenTieredItemType.HOE, () -> new WoodenHoeItem(woodType, itemTier));
    }

    private RegistryObject<Item> registerSwordItem(IWoodenItemTier itemTier, IWoodType woodType) {
        return this.register(itemTier, woodType, WoodenTieredItemType.SWORD, () -> new WoodenSwordItem(woodType, itemTier));
    }

    private RegistryObject<Item> registerAxeItem(IWoodenItemTier itemTier, IWoodType woodType) {
        return this.register(itemTier, woodType, WoodenTieredItemType.AXE, () -> new WoodenAxeItem(woodType, itemTier));
    }

    private RegistryObject<Item> registerPickaxeItem(IWoodenItemTier itemTier, IWoodType woodType) {
        return this.register(itemTier, woodType, WoodenTieredItemType.PICKAXE, () -> new WoodenPickAxeItem(woodType, itemTier));
    }

    private RegistryObject<Item> registerShovelItem(IWoodenItemTier itemTier, IWoodType woodType) {
        return this.register(itemTier, woodType, WoodenTieredItemType.SHOVEL, () -> new WoodenShovelItem(woodType, itemTier));
    }
}

