/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry.resource;

import java.util.HashMap;
import java.util.Map;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.resource.IWoodenResource;
import yamahari.ilikewood.registry.resource.IWoodenResourceRegistry;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenSlabResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class WoodenResourceRegistry
implements IWoodenResourceRegistry {
    private final Map<IWoodType, IWoodenPlanksResource> planks = new HashMap<IWoodType, IWoodenPlanksResource>();
    private final Map<IWoodType, IWoodenLogResource> logs = new HashMap<IWoodType, IWoodenLogResource>();
    private final Map<IWoodType, IWoodenStrippedLogResource> strippedLogs = new HashMap<IWoodType, IWoodenStrippedLogResource>();
    private final Map<IWoodType, IWoodenSlabResource> slabs = new HashMap<IWoodType, IWoodenSlabResource>();
    private final Map<WoodenBlockType, Map<IWoodType, IWoodenResource>> blockResources = new HashMap<WoodenBlockType, Map<IWoodType, IWoodenResource>>();
    private final Map<WoodenItemType, Map<IWoodType, IWoodenResource>> itemResources = new HashMap<WoodenItemType, Map<IWoodType, IWoodenResource>>();

    @Override
    public void registerPlanksResource(IWoodType woodType, IWoodenPlanksResource planks) {
        this.planks.put(woodType, planks);
    }

    @Override
    public void registerLogResource(IWoodType woodType, IWoodenLogResource log) {
        this.logs.put(woodType, log);
    }

    @Override
    public void registerStrippedLogResource(IWoodType woodType, IWoodenStrippedLogResource strippedLog) {
        this.strippedLogs.put(woodType, strippedLog);
    }

    @Override
    public void registerSlabResource(IWoodType woodType, IWoodenSlabResource slab) {
        this.slabs.put(woodType, slab);
    }

    @Override
    public void registerBlockResource(IWoodType woodType, WoodenBlockType blockType, IWoodenResource resource) {
        this.blockResources.computeIfAbsent(blockType, b -> new HashMap()).put(woodType, resource);
    }

    @Override
    public void registerItemResource(IWoodType woodType, WoodenItemType itemType, IWoodenResource resource) {
        this.itemResources.computeIfAbsent(itemType, i -> new HashMap()).put(woodType, resource);
    }

    public boolean hasPlanks(IWoodType woodType) {
        return this.planks.containsKey(woodType);
    }

    public boolean hasLog(IWoodType woodType) {
        return this.logs.containsKey(woodType);
    }

    public boolean hasStrippedLog(IWoodType woodType) {
        return this.strippedLogs.containsKey(woodType);
    }

    public boolean hasSlab(IWoodType woodType) {
        return this.slabs.containsKey(woodType);
    }

    public boolean hasBlockResource(IWoodType woodType, WoodenBlockType blockType) {
        Map<IWoodType, IWoodenResource> resourceMap = this.blockResources.get(blockType);
        return resourceMap != null && resourceMap.containsKey(woodType);
    }

    public boolean hasItemResource(IWoodType woodType, WoodenItemType itemType) {
        Map<IWoodType, IWoodenResource> resourceMap = this.itemResources.get(itemType);
        return resourceMap != null && resourceMap.containsKey(woodType);
    }

    public IWoodenPlanksResource getPlanks(IWoodType woodType) {
        return this.planks.get(woodType);
    }

    public IWoodenLogResource getLog(IWoodType woodType) {
        return this.logs.get(woodType);
    }

    public IWoodenStrippedLogResource getStrippedLog(IWoodType woodType) {
        return this.strippedLogs.get(woodType);
    }

    public IWoodenSlabResource getSlab(IWoodType woodType) {
        return this.slabs.get(woodType);
    }

    public IWoodenResource getBlockResource(IWoodType woodType, WoodenBlockType blockType) {
        return this.blockResources.get(blockType).get(woodType);
    }

    public IWoodenResource getItemResource(IWoodType woodType, WoodenItemType itemType) {
        return this.itemResources.get(itemType).get(woodType);
    }
}

