/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry.woodenitemtier;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.crafting.Ingredient;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTier;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class DefaultWoodenItemTier
implements IWoodenItemTier {
    public static final Map<String, Integer> DEFAULT_HARVEST_LEVEL = new ImmutableMap.Builder().put((Object)"wood", (Object)0).put((Object)"stone", (Object)1).put((Object)"iron", (Object)2).put((Object)"diamond", (Object)3).put((Object)"golden", (Object)0).put((Object)"netherite", (Object)4).build();
    public static final Map<String, Integer> DEFAULT_MAX_USES = new ImmutableMap.Builder().put((Object)"wood", (Object)59).put((Object)"stone", (Object)131).put((Object)"iron", (Object)250).put((Object)"diamond", (Object)1561).put((Object)"golden", (Object)32).put((Object)"netherite", (Object)2031).build();
    public static final Map<String, Float> DEFAULT_EFFICIENCY = new ImmutableMap.Builder().put((Object)"wood", (Object)Float.valueOf(2.0f)).put((Object)"stone", (Object)Float.valueOf(4.0f)).put((Object)"iron", (Object)Float.valueOf(6.0f)).put((Object)"diamond", (Object)Float.valueOf(8.0f)).put((Object)"golden", (Object)Float.valueOf(12.0f)).put((Object)"netherite", (Object)Float.valueOf(9.0f)).build();
    public static final Map<String, Float> DEFAULT_ATTACK_DAMAGE = new ImmutableMap.Builder().put((Object)"wood", (Object)Float.valueOf(0.0f)).put((Object)"stone", (Object)Float.valueOf(1.0f)).put((Object)"iron", (Object)Float.valueOf(2.0f)).put((Object)"diamond", (Object)Float.valueOf(3.0f)).put((Object)"golden", (Object)Float.valueOf(0.0f)).put((Object)"netherite", (Object)Float.valueOf(4.0f)).build();
    public static final Map<String, Integer> DEFAULT_ENCHANTABILITY = new ImmutableMap.Builder().put((Object)"wood", (Object)15).put((Object)"stone", (Object)5).put((Object)"iron", (Object)14).put((Object)"diamond", (Object)10).put((Object)"golden", (Object)22).put((Object)"netherite", (Object)15).build();
    public static final Map<String, Map<String, Float>> DEFAULT_TIERED_ATTACK_SPEED = new ImmutableMap.Builder().put((Object)"wood", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.2f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).put((Object)"stone", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.2f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-2.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).put((Object)"iron", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.1f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-1.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).put((Object)"diamond", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(0.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).put((Object)"golden", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).put((Object)"netherite", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(0.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(-2.8f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(-2.4f))).build();
    public static final Map<String, Map<String, Float>> DEFAULT_TIERED_ATTACK_DAMAGE = new ImmutableMap.Builder().put((Object)"wood", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(6.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(0.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).put((Object)"stone", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(7.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-1.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).put((Object)"iron", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(6.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-2.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).put((Object)"diamond", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(5.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-3.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).put((Object)"golden", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(6.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(0.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).put((Object)"netherite", (Object)ImmutableMap.of((Object)WoodenTieredItemType.AXE.getName(), (Object)Float.valueOf(5.0f), (Object)WoodenTieredItemType.HOE.getName(), (Object)Float.valueOf(-4.0f), (Object)WoodenTieredItemType.PICKAXE.getName(), (Object)Float.valueOf(1.0f), (Object)WoodenTieredItemType.SHOVEL.getName(), (Object)Float.valueOf(1.5f), (Object)WoodenTieredItemType.SWORD.getName(), (Object)Float.valueOf(3.0f))).build();
    public static final Map<String, Map<WoodenTieredItemType, IWoodenItemTier.Properties>> DEFAULT_PROPERTIES = new ImmutableMap.Builder().put((Object)"wood", DefaultWoodenItemTier.getDefaultWoodProperties()).put((Object)"stone", DefaultWoodenItemTier.getDefaultProperties("stone")).put((Object)"iron", DefaultWoodenItemTier.getDefaultProperties("iron")).put((Object)"diamond", DefaultWoodenItemTier.getDefaultProperties("diamond")).put((Object)"golden", DefaultWoodenItemTier.getDefaultProperties("golden")).put((Object)"netherite", DefaultWoodenItemTier.getDefaultProperties("netherite")).build();
    private final IWoodType woodType;
    private final String modId;
    private final String name;
    private final boolean isWood;
    private final int level;
    private final int uses;
    private final float speed;
    private final float attackDamageBonus;
    private final int enchantmentValue;
    private final Supplier<Ingredient> repairIngredient;
    private final Map<WoodenTieredItemType, IWoodenItemTier.Properties> properties;

    public DefaultWoodenItemTier(IWoodType woodType, String modId, String name, Supplier<Ingredient> repairIngredient) {
        this(woodType, modId, name, true, repairIngredient);
    }

    public DefaultWoodenItemTier(IWoodType woodType, String modId, String name, boolean isWood, Supplier<Ingredient> repairIngredient) {
        this(woodType, modId, name, isWood, DEFAULT_HARVEST_LEVEL.get(isWood ? "wood" : name), DEFAULT_MAX_USES.get(isWood ? "wood" : name), DEFAULT_EFFICIENCY.get(isWood ? "wood" : name).floatValue(), DEFAULT_ATTACK_DAMAGE.get(isWood ? "wood" : name).floatValue(), DEFAULT_ENCHANTABILITY.get(isWood ? "wood" : name), repairIngredient);
    }

    public DefaultWoodenItemTier(IWoodType woodType, String modId, String name, boolean isWood, int level, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<Ingredient> repairIngredient) {
        this.woodType = woodType;
        this.modId = modId;
        this.name = name;
        this.isWood = isWood;
        this.level = level;
        this.uses = uses;
        this.speed = speed;
        this.attackDamageBonus = attackDamageBonus;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
        this.properties = DEFAULT_PROPERTIES.get(isWood ? "wood" : name);
    }

    private static Map<WoodenTieredItemType, IWoodenItemTier.Properties> getDefaultWoodProperties() {
        return DefaultWoodenItemTier.getDefaultProperties("", true);
    }

    private static Map<WoodenTieredItemType, IWoodenItemTier.Properties> getDefaultProperties(String name) {
        return DefaultWoodenItemTier.getDefaultProperties(name, false);
    }

    private static Map<WoodenTieredItemType, IWoodenItemTier.Properties> getDefaultProperties(String name, boolean isWood) {
        HashMap properties = new HashMap();
        WoodenTieredItemType.getAll().forEach(tieredItemType -> {
            String type = tieredItemType.getName();
            properties.put(tieredItemType, new IWoodenItemTier.Properties(DEFAULT_TIERED_ATTACK_SPEED.get(isWood ? "wood" : name).get(type).floatValue(), DEFAULT_TIERED_ATTACK_DAMAGE.get(isWood ? "wood" : name).get(type).floatValue(), isWood ? 200 : -1));
        });
        return Collections.unmodifiableMap(properties);
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isWood() {
        return this.isWood;
    }

    public int m_6604_() {
        return this.level;
    }

    public int m_6609_() {
        return this.uses;
    }

    public float m_6624_() {
        return this.speed;
    }

    public float m_6631_() {
        return this.attackDamageBonus;
    }

    public int m_6601_() {
        return this.enchantmentValue;
    }

    @Nonnull
    public Ingredient m_6282_() {
        return this.repairIngredient.get();
    }

    @Override
    public IWoodenItemTier.Properties getProperties(WoodenTieredItemType tieredItemType) {
        return this.properties.get(tieredItemType);
    }
}

