/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry.woodenitemtier;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTier;
import yamahari.ilikewood.registry.woodenitemtier.IWoodenItemTierRegistry;

public final class WoodenItemTierRegistry
implements IWoodenItemTierRegistry {
    private final List<IWoodenItemTier> woodenItemTiers = new ArrayList<IWoodenItemTier>();

    @Override
    public void register(IWoodenItemTier woodenItemTier) {
        this.woodenItemTiers.add(woodenItemTier);
    }

    public Stream<IWoodenItemTier> getWoodenItemTiers() {
        try {
            String dataModId = System.getProperty("ilikewood.datagen.modid");
            if (dataModId != null) {
                return this.woodenItemTiers.stream().filter(itemTier -> !itemTier.isWood() || itemTier.getModId().equals(dataModId));
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            ILikeWood.LOGGER.error(e.getMessage());
        }
        return this.woodenItemTiers.stream().filter(itemTier -> ModList.get().isLoaded(itemTier.getModId()));
    }
}

