/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry.woodtype;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class DefaultWoodType
implements IWoodType {
    public static final Map<WoodenBlockType, IWoodType.Properties> DEFAULT_BLOCK_PROPERTIES = DefaultWoodType.createDefaultBlockProperties();
    public static final Map<WoodenItemType, IWoodType.Properties> DEFAULT_ITEM_PROPERTIES = DefaultWoodType.createDefaultItemProperties();
    public static final Set<WoodenBlockType> DEFAULT_BLOCK_TYPES = Collections.unmodifiableSet(WoodenBlockType.getAll().collect(Collectors.toSet()));
    public static final Set<WoodenItemType> DEFAULT_ITEM_TYPES = Collections.unmodifiableSet(WoodenItemType.getAll().collect(Collectors.toSet()));
    public static final Set<WoodenTieredItemType> DEFAULT_TIERED_ITEM_TYPES = Collections.unmodifiableSet(WoodenTieredItemType.getAll().collect(Collectors.toSet()));
    public static final Set<WoodenEntityType> DEFAULT_ENTITY_TYPES = Collections.unmodifiableSet(WoodenEntityType.getAll().collect(Collectors.toSet()));
    public static final Set<WoodenBlockType> DEFAULT_BUILTIN_BLOCK_TYPES = Collections.emptySet();
    public static final Set<WoodenItemType> DEFAULT_BUILTIN_ITEM_TYPES = Collections.emptySet();
    private final String modId;
    private final String name;
    private final IWoodType.Colors colors;

    public DefaultWoodType(String modId, String name, IWoodType.Colors colors) {
        this.modId = modId;
        this.name = name;
        this.colors = colors;
    }

    private static Map<WoodenBlockType, IWoodType.Properties> createDefaultBlockProperties() {
        HashMap<WoodenBlockType, IWoodType.Properties> properties = new HashMap<WoodenBlockType, IWoodType.Properties>();
        properties.put(WoodenBlockType.PANELS, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.PANELS_STAIRS, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.PANELS_SLAB, new IWoodType.Properties(150));
        properties.put(WoodenBlockType.BARREL, new IWoodType.Properties(300));
        WoodenBlockType.getBeds().forEach(bedBlockType -> properties.put((WoodenBlockType)bedBlockType, new IWoodType.Properties(400)));
        properties.put(WoodenBlockType.BOOKSHELF, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.COMPOSTER, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.CRAFTING_TABLE, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.CHEST, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.SAWMILL, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.LECTERN, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.LADDER, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.SCAFFOLDING, new IWoodType.Properties(100));
        properties.put(WoodenBlockType.SOUL_TORCH, new IWoodType.Properties(400));
        properties.put(WoodenBlockType.TORCH, new IWoodType.Properties(400));
        properties.put(WoodenBlockType.WALL_TORCH, new IWoodType.Properties(400));
        properties.put(WoodenBlockType.WALL_SOUL_TORCH, new IWoodType.Properties(400));
        properties.put(WoodenBlockType.LOG_PILE, new IWoodType.Properties(400));
        properties.put(WoodenBlockType.POST, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.STRIPPED_POST, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.WALL, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.CHAIR, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.TABLE, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.STOOL, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.SINGLE_DRESSER, new IWoodType.Properties(300));
        properties.put(WoodenBlockType.CAMPFIRE, new IWoodType.Properties(-1));
        properties.put(WoodenBlockType.SOUL_CAMPFIRE, new IWoodType.Properties(-1));
        properties.put(WoodenBlockType.CRATE, new IWoodType.Properties(300));
        return properties;
    }

    private static Map<WoodenItemType, IWoodType.Properties> createDefaultItemProperties() {
        HashMap<WoodenItemType, IWoodType.Properties> properties = new HashMap<WoodenItemType, IWoodType.Properties>();
        properties.put(WoodenItemType.STICK, new IWoodType.Properties(100));
        properties.put(WoodenItemType.BOW, new IWoodType.Properties(300));
        properties.put(WoodenItemType.CROSSBOW, new IWoodType.Properties(300));
        properties.put(WoodenItemType.FISHING_ROD, new IWoodType.Properties(300));
        properties.put(WoodenItemType.ITEM_FRAME, new IWoodType.Properties(-1));
        properties.put(WoodenItemType.PAINTING, new IWoodType.Properties(-1));
        return properties;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IWoodType.Properties getProperties(WoodenBlockType blockType) {
        return DEFAULT_BLOCK_PROPERTIES.get(blockType);
    }

    @Override
    public IWoodType.Properties getProperties(WoodenItemType itemType) {
        return DEFAULT_ITEM_PROPERTIES.get(itemType);
    }

    @Override
    public Set<WoodenBlockType> getBlockTypes() {
        return DEFAULT_BLOCK_TYPES;
    }

    @Override
    public Set<WoodenItemType> getItemTypes() {
        return DEFAULT_ITEM_TYPES;
    }

    @Override
    public Set<WoodenEntityType> getEntityTypes() {
        return DEFAULT_ENTITY_TYPES;
    }

    @Override
    public Set<WoodenTieredItemType> getTieredItemTypes() {
        return DEFAULT_TIERED_ITEM_TYPES;
    }

    @Override
    public Set<WoodenBlockType> getBuiltinBlockTypes() {
        return DEFAULT_BUILTIN_BLOCK_TYPES;
    }

    @Override
    public Set<WoodenItemType> getBuiltinItemTypes() {
        return DEFAULT_BUILTIN_ITEM_TYPES;
    }

    @Override
    public IWoodType.Colors getColors() {
        return this.colors;
    }
}

