/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.registry.woodtype;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.registry.woodtype.IWoodTypeRegistry;

public final class WoodTypeRegistry
implements IWoodTypeRegistry {
    private final Map<ResourceLocation, IWoodType> woodTypes = new HashMap<ResourceLocation, IWoodType>();

    @Override
    public void register(IWoodType woodType) {
        this.woodTypes.put(new ResourceLocation(woodType.getModId(), woodType.getName()), woodType);
    }

    public IWoodType get(ResourceLocation resourceLocation) {
        if (!this.woodTypes.containsKey(resourceLocation)) {
            throw new IllegalArgumentException(String.format("wood type [%s] was not registered", resourceLocation.toString()));
        }
        return this.woodTypes.get(resourceLocation);
    }

    @Override
    public Stream<IWoodType> getWoodTypes() {
        try {
            String dataModId = System.getProperty("ilikewood.datagen.modid");
            if (dataModId != null) {
                return this.woodTypes.values().stream().filter(woodType -> woodType.getModId().equals(dataModId));
            }
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            ILikeWood.LOGGER.error(e.getMessage());
        }
        return this.woodTypes.values().stream().filter(woodType -> ModList.get().isLoaded(woodType.getModId()));
    }
}

