/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.IModPlugin;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.DummyWoodType;

public final class Util {
    public static final IWoodType DUMMY_WOOD_TYPE = new DummyWoodType();

    private Util() {
    }

    @Nullable
    public static String getDataGenModId() {
        String dataGenModId = null;
        try {
            dataGenModId = System.getProperty("ilikewood.datagen.modid");
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException e) {
            ILikeWood.LOGGER.error(e.getMessage());
        }
        return dataGenModId;
    }

    public static String toRegistryName(String ... elements) {
        return StringUtils.join((Object[])elements, (String)"_");
    }

    public static String toPath(String ... elements) {
        return StringUtils.join((Object[])elements, (String)"/");
    }

    public static ItemLike getIngredient(String name, Class<?> objectHolder) {
        try {
            Field block = objectHolder.getDeclaredField(name);
            return (ItemLike)block.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            ILikeWood.LOGGER.error(e.getMessage());
            return null;
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from.m_122434_() == Direction.Axis.Y || to.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    private static String toTranslationNameImpl(String registryName) {
        return Arrays.stream(StringUtils.split((String)registryName, (char)'_')).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String toTranslationName(String registryName) {
        for (IModPlugin plugin : ILikeWood.PLUGINS) {
            if (!registryName.startsWith(plugin.getModId())) continue;
            return Util.toTranslationNameImpl(registryName.substring(plugin.getModId().length() + 1));
        }
        return Util.toTranslationNameImpl(registryName);
    }

    public static RGBColor HSLColorToRGBColor(HSLColor color) {
        float b;
        float g;
        float r;
        float c = (1.0f - Math.abs(2.0f * color.l() - 1.0f)) * color.s();
        float hh = color.h() / 60.0f;
        float x = c * (1.0f - Math.abs(hh % 2.0f - 1.0f));
        if (0.0f <= hh && hh < 1.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (1.0f <= hh && hh < 2.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (2.0f <= hh && hh < 3.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (3.0f <= hh && hh < 4.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (4.0f <= hh && hh < 5.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        float m = color.l() - c / 2.0f;
        return new RGBColor(r + m, g + m, b + m);
    }

    public static HSLColor RGBColorToHSLColor(RGBColor color) {
        float h;
        float epsilon = 1.0E-8f;
        float min = Math.min(Math.min(color.r(), color.g()), color.b());
        float max = Math.max(Math.max(color.r(), color.g()), color.b());
        float c = max - min;
        float l = (min + max) / 2.0f;
        if (Math.abs(c) < 1.0E-8f) {
            h = 0.0f;
        } else if (max == color.r()) {
            h = 60.0f * (0.0f + (color.g() - color.b()) / c);
        } else if (max == color.g()) {
            h = 60.0f * (2.0f + (color.b() - color.r()) / c);
        } else if (max == color.b()) {
            h = 60.0f * (4.0f + (color.r() - color.g()) / c);
        } else {
            throw new RuntimeException("");
        }
        h = (h % 360.0f + 360.0f) % 360.0f;
        float s = Math.abs(l) < 1.0E-8f || Math.abs(1.0 - (double)l) < (double)1.0E-8f ? 0.0f : c / (1.0f - Math.abs(2.0f * max - c - 1.0f));
        return new HSLColor(h, s, l);
    }

    public static int RGBAtoABGR(int rgba) {
        return (rgba & 0xFF) << 24 | (rgba >> 8 & 0xFF) << 16 | (rgba >> 16 & 0xFF) << 8 | rgba >> 24 & 0xFF;
    }

    public static int[] createColorShades(RGBColor rgb, int n, float min, float max) {
        Preconditions.checkArgument((0.0f <= min && min <= 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((0.0f <= max && max <= 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((min < max ? 1 : 0) != 0);
        float diff = max - min;
        int[] shades = new int[n];
        HSLColor hsl = Util.RGBColorToHSLColor(rgb);
        float increment = diff / (float)n;
        for (int i = 0; i < n; ++i) {
            RGBColor shade = Util.HSLColorToRGBColor(new HSLColor(hsl.h(), hsl.s(), min + increment / 2.0f + (float)i * increment));
            shades[i] = 0xFF000000 | (Math.round(shade.b() * 255.0f) & 0xFF) << 16 | (Math.round(shade.g() * 255.0f) & 0xFF) << 8 | Math.round(shade.r() * 255.0f) & 0xFF;
        }
        return shades;
    }

    public static Map<Integer, Integer> createShadeColorMap(DyeColor dyeColor, int[] colors) {
        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
        float[] textureDiffuseColors = dyeColor.m_41068_();
        RGBColor baseColor = new RGBColor(textureDiffuseColors[0], textureDiffuseColors[1], textureDiffuseColors[2]);
        int[] shades = switch (dyeColor) {
            case DyeColor.WHITE -> Util.createColorShades(new RGBColor(0.9490196f, 0.9490196f, 0.9490196f), colors.length + 1, 0.5f, 1.0f);
            case DyeColor.BLACK -> Util.createColorShades(baseColor, colors.length + 1, 0.0f, 0.5f);
            default -> Util.createColorShades(baseColor, colors.length + 1, 0.3f, 0.8f);
        };
        for (int i = 0; i < colors.length; ++i) {
            colorMap.put(Util.RGBAtoABGR(colors[i] << 8 | 0xFF), shades[i + 1]);
        }
        return Collections.unmodifiableMap(colorMap);
    }

    public record HSLColor(float h, float s, float l) {
        public HSLColor {
            Preconditions.checkArgument((0.0f <= h && h <= 360.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((0.0f <= s && s <= 1.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((0.0f <= l && l <= 1.0f ? 1 : 0) != 0);
        }
    }

    public record RGBColor(float r, float g, float b) {
        public RGBColor {
            Preconditions.checkArgument((0.0f <= r && r <= 1.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((0.0f <= g && g <= 1.0f ? 1 : 0) != 0);
            Preconditions.checkArgument((0.0f <= b && b <= 1.0f ? 1 : 0) != 0);
        }
    }
}

