/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.validation;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.IObjectType;
import yamahari.ilikewood.registry.objecttype.IObjectTypeVisitor;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.objecttype.WoodenTieredItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.validation.ObjectTypeValidator;

public final class WoodTypeValidator {
    private static final Map<IObjectType, Set<ResourceRequirement>> RESOURCE_REQUIREMENTS;
    private static final Set<ResourceRequirement> REQUIRES_PLANKS;
    private static final Set<ResourceRequirement> REQUIRES_NONE;
    private static final Set<ResourceRequirement> REQUIRES_LOGS;
    private static final Set<ResourceRequirement> REQUIRES_STRIPPED_LOGS;
    private static final Set<ResourceRequirement> REQUIRES_LOGS_BOTH;

    private WoodTypeValidator() {
    }

    private static <T extends IObjectType> boolean validateRequirements(StringBuilder builder, Set<T> objectTypes, T objectType, IWoodType woodType, BiFunction<IWoodType, T, Boolean> biFunction) {
        boolean result = true;
        if (objectTypes.contains(objectType)) {
            for (ResourceRequirement requirement : RESOURCE_REQUIREMENTS.get(objectType)) {
                switch (requirement) {
                    case PLANKS: {
                        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasPlanks(woodType)) break;
                        builder.append(String.format("Resource requirement \"planks\" of object type \"%s\" for wood type \"%s\" was not satisfied.", objectType.getName(), woodType.getName()));
                        builder.append(System.lineSeparator());
                        result = false;
                        break;
                    }
                    case LOGS: {
                        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasLog(woodType)) break;
                        builder.append(String.format("Resource requirement \"logs\" of object type \"%s\" for wood type \"%s\" was not satisfied.", objectType.getName(), woodType.getName()));
                        builder.append(System.lineSeparator());
                        result = false;
                        break;
                    }
                    case STRIPPED_LOGS: {
                        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasStrippedLog(woodType)) break;
                        builder.append(String.format("Resource requirement \"stripped logs\" of object type \"%s\" for wood type \"%s\" was not satisfied.", objectType.getName(), woodType.getName()));
                        builder.append(System.lineSeparator());
                        result = false;
                        break;
                    }
                    case SLAB: {
                        if (ILikeWood.WOODEN_RESOURCE_REGISTRY.hasSlab(woodType)) break;
                        builder.append(String.format("Resource requirement \"slabs\" of object type \"%s\" for wood type \"%s\" was not satisfied.", objectType.getName(), woodType.getName()));
                        builder.append(System.lineSeparator());
                        result = false;
                    }
                }
            }
        } else if (!biFunction.apply(woodType, (IWoodType)((Object)objectType)).booleanValue()) {
            builder.append(String.format("Block resource requirement \"%s\" of built-in object type \"%s\" for wood type \"%s\" was not satisfied.", objectType.getName(), objectType.getName(), woodType.getName()));
            builder.append(System.lineSeparator());
            result = false;
        }
        return result;
    }

    private static boolean validateDependencies(StringBuilder builder, IObjectType objectType, IObjectTypeVisitor visitor, IWoodType woodType) {
        return ObjectTypeValidator.getDependencies(objectType).stream().map(ds -> ds.stream().reduce(true, (a, dependency) -> {
            boolean x = dependency.acceptVisitor(visitor);
            if (!x) {
                builder.append(String.format("Dependency \"%s\" of object type \"%s\" for wood type \"%s\" was not satisfied.", dependency.getName(), objectType.getName(), woodType.getName()));
                builder.append(System.lineSeparator());
            }
            return a != false && x;
        }, Boolean::logicalAnd)).reduce(false, Boolean::logicalOr);
    }

    private static <T extends IObjectType> boolean validateExclusivity(StringBuilder builder, Set<T> objectTypes, Set<T> builtinObjectTypes, IWoodType woodType) {
        boolean result = true;
        Sets.SetView intersection = Sets.intersection(objectTypes, builtinObjectTypes);
        if (!intersection.isEmpty()) {
            builder.append(String.format("Object types set and builtin object types set for wood type \"%s\" set are not disconnected. Duplicates:", woodType.getName()));
            builder.append(System.lineSeparator());
            for (IObjectType duplicate : intersection) {
                builder.append(duplicate.getName());
                builder.append(System.lineSeparator());
            }
            result = false;
        }
        return result;
    }

    private static <T extends IObjectType> boolean validateProperties(StringBuilder builder, Set<T> objectTypes, IWoodType woodType, BiFunction<IWoodType, T, IWoodType.Properties> biFunction) {
        boolean result = true;
        for (IObjectType objectType : objectTypes) {
            IWoodType.Properties properties = biFunction.apply(woodType, (IWoodType)((Object)objectType));
            if (properties == null) {
                builder.append(String.format("Missing properties for block type \"%s\" of wood type \"%s\".", objectType.getName(), woodType.getName()));
                builder.append(System.lineSeparator());
                result = false;
                continue;
            }
            if (properties.burnTime() >= -1) continue;
            builder.append(String.format("Invalid burn time \"%d\" for block type \"%s\" of wood type \"%s\".", properties.burnTime(), objectType.getName(), woodType.getName()));
            builder.append(System.lineSeparator());
            result = false;
        }
        return result;
    }

    public static boolean validate(StringBuilder builder, IWoodType woodType) {
        final Set<WoodenBlockType> blockTypes = woodType.getBlockTypes();
        final Set<WoodenBlockType> builtinBlockTypes = woodType.getBuiltinBlockTypes();
        final Set<WoodenItemType> itemTypes = woodType.getItemTypes();
        final Set<WoodenItemType> builtinItemTypes = woodType.getBuiltinItemTypes();
        final Set<WoodenEntityType> entityTypes = woodType.getEntityTypes();
        final Set<WoodenTieredItemType> tieredItemTypes = woodType.getTieredItemTypes();
        IObjectTypeVisitor visitor = new IObjectTypeVisitor(){

            @Override
            public boolean visit(WoodenBlockType blockType) {
                return blockTypes.contains(blockType) || builtinBlockTypes.contains(blockType);
            }

            @Override
            public boolean visit(WoodenItemType itemType) {
                return itemTypes.contains(itemType) || builtinItemTypes.contains(itemType);
            }

            @Override
            public boolean visit(WoodenTieredItemType tieredItemType) {
                return tieredItemTypes.contains(tieredItemType);
            }

            @Override
            public boolean visit(WoodenEntityType entityType) {
                return entityTypes.contains(entityType);
            }
        };
        boolean exclusivityValidation = WoodTypeValidator.validateExclusivity(builder, blockTypes, builtinBlockTypes, woodType) && WoodTypeValidator.validateExclusivity(builder, itemTypes, builtinItemTypes, woodType);
        boolean propertiesValidation = WoodTypeValidator.validateProperties(builder, blockTypes, woodType, IWoodType::getProperties) && WoodTypeValidator.validateProperties(builder, itemTypes, woodType, IWoodType::getProperties);
        Boolean blockTypesValidation = WoodenBlockType.getAll().filter(blockType -> blockTypes.contains(blockType) || builtinBlockTypes.contains(blockType)).map(blockType -> WoodTypeValidator.validateRequirements(builder, blockTypes, blockType, woodType, ILikeWood.WOODEN_RESOURCE_REGISTRY::hasBlockResource) && WoodTypeValidator.validateDependencies(builder, blockType, visitor, woodType)).reduce(true, Boolean::logicalAnd);
        Boolean itemTypesValidation = WoodenItemType.getAll().filter(itemType -> itemTypes.contains(itemType) || builtinItemTypes.contains(itemType)).map(itemType -> WoodTypeValidator.validateRequirements(builder, itemTypes, itemType, woodType, ILikeWood.WOODEN_RESOURCE_REGISTRY::hasItemResource) && WoodTypeValidator.validateDependencies(builder, itemType, visitor, woodType)).reduce(true, Boolean::logicalAnd);
        Boolean tieredItemTypesValidation = WoodenTieredItemType.getAll().filter(tieredItemTypes::contains).map(tieredItemType -> WoodTypeValidator.validateDependencies(builder, tieredItemType, visitor, woodType)).reduce(true, Boolean::logicalAnd);
        Boolean entityTypesValidation = WoodenEntityType.getAll().filter(entityTypes::contains).map(entityType -> WoodTypeValidator.validateDependencies(builder, entityType, visitor, woodType)).reduce(true, Boolean::logicalAnd);
        return exclusivityValidation && propertiesValidation && blockTypesValidation != false && itemTypesValidation != false && tieredItemTypesValidation != false && entityTypesValidation != false;
    }

    static {
        REQUIRES_PLANKS = Sets.immutableEnumSet((Enum)ResourceRequirement.PLANKS, (Enum[])new ResourceRequirement[0]);
        REQUIRES_NONE = Collections.emptySet();
        REQUIRES_LOGS = Sets.immutableEnumSet((Enum)ResourceRequirement.LOGS, (Enum[])new ResourceRequirement[0]);
        REQUIRES_STRIPPED_LOGS = Sets.immutableEnumSet((Enum)ResourceRequirement.STRIPPED_LOGS, (Enum[])new ResourceRequirement[0]);
        REQUIRES_LOGS_BOTH = Sets.immutableEnumSet((Enum)ResourceRequirement.LOGS, (Enum[])new ResourceRequirement[]{ResourceRequirement.STRIPPED_LOGS});
        HashMap<IObjectType, Set<ResourceRequirement>> resourceRequirements = new HashMap<IObjectType, Set<ResourceRequirement>>();
        resourceRequirements.put(WoodenBlockType.PANELS, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.PANELS_STAIRS, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.PANELS_SLAB, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.BARREL, REQUIRES_NONE);
        WoodenBlockType.getBeds().forEach(blockType -> resourceRequirements.put((IObjectType)blockType, REQUIRES_PLANKS));
        resourceRequirements.put(WoodenBlockType.BOOKSHELF, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.COMPOSTER, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.CRAFTING_TABLE, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.CHEST, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.SAWMILL, (Set<ResourceRequirement>)Sets.immutableEnumSet((Enum)ResourceRequirement.PLANKS, (Enum[])new ResourceRequirement[]{ResourceRequirement.LOGS, ResourceRequirement.STRIPPED_LOGS}));
        resourceRequirements.put(WoodenBlockType.LECTERN, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.LADDER, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.SCAFFOLDING, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.SOUL_TORCH, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.TORCH, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.WALL_TORCH, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.WALL_SOUL_TORCH, REQUIRES_NONE);
        resourceRequirements.put(WoodenBlockType.LOG_PILE, REQUIRES_LOGS);
        resourceRequirements.put(WoodenBlockType.POST, REQUIRES_LOGS);
        resourceRequirements.put(WoodenBlockType.STRIPPED_POST, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenBlockType.WALL, REQUIRES_LOGS_BOTH);
        resourceRequirements.put(WoodenBlockType.CHAIR, REQUIRES_STRIPPED_LOGS);
        resourceRequirements.put(WoodenBlockType.TABLE, REQUIRES_LOGS_BOTH);
        resourceRequirements.put(WoodenBlockType.STOOL, REQUIRES_STRIPPED_LOGS);
        resourceRequirements.put(WoodenBlockType.SINGLE_DRESSER, REQUIRES_LOGS_BOTH);
        resourceRequirements.put(WoodenBlockType.CAMPFIRE, REQUIRES_LOGS);
        resourceRequirements.put(WoodenBlockType.SOUL_CAMPFIRE, REQUIRES_LOGS);
        resourceRequirements.put(WoodenBlockType.CRATE, REQUIRES_NONE);
        resourceRequirements.put(WoodenItemType.STICK, REQUIRES_NONE);
        resourceRequirements.put(WoodenItemType.BOW, REQUIRES_NONE);
        resourceRequirements.put(WoodenItemType.CROSSBOW, REQUIRES_NONE);
        resourceRequirements.put(WoodenItemType.FISHING_ROD, REQUIRES_NONE);
        resourceRequirements.put(WoodenItemType.ITEM_FRAME, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenItemType.PAINTING, REQUIRES_PLANKS);
        resourceRequirements.put(WoodenTieredItemType.AXE, REQUIRES_NONE);
        resourceRequirements.put(WoodenTieredItemType.HOE, REQUIRES_NONE);
        resourceRequirements.put(WoodenTieredItemType.PICKAXE, REQUIRES_NONE);
        resourceRequirements.put(WoodenTieredItemType.SHOVEL, REQUIRES_NONE);
        resourceRequirements.put(WoodenTieredItemType.SWORD, REQUIRES_NONE);
        resourceRequirements.put(WoodenEntityType.ITEM_FRAME, REQUIRES_NONE);
        resourceRequirements.put(WoodenEntityType.CHAIR, REQUIRES_NONE);
        resourceRequirements.put(WoodenEntityType.PAINTING, REQUIRES_NONE);
        RESOURCE_REQUIREMENTS = Collections.unmodifiableMap(resourceRequirements);
    }

    private static enum ResourceRequirement {
        PLANKS,
        LOGS,
        STRIPPED_LOGS,
        SLAB;

    }
}

