/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Config;
import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.RailwaysClient;
import com.railwayteam.railways.base.data.lang.CRLangPartials;
import com.railwayteam.railways.base.data.recipe.RailwaysSequencedAssemblyRecipeGen;
import com.railwayteam.railways.base.data.recipe.RailwaysStandardRecipeGen;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.registry.CRCommands;
import com.railwayteam.railways.util.packet.PacketSender;
import com.simibubi.create.foundation.ModFilePackResources;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.LangPartial;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="railways")
public class Railways {
    public static final String MODID = "railways";
    public static Railways instance;
    public static final Logger LOGGER;
    public static final ModSetup setup;
    public static final String VERSION;
    private static final CreateRegistrate REGISTRATE;
    public static IEventBus MOD_EVENT_BUS;

    public Railways() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        ModSetup.register();
        REGISTRATE.registerEventListeners(MOD_EVENT_BUS);
        MOD_EVENT_BUS.addListener(this::setup);
        MOD_EVENT_BUS.addListener(EventPriority.LOWEST, Railways::gatherData);
        MOD_EVENT_BUS.addListener(this::registerModelLayers);
        MOD_EVENT_BUS.addListener(this::addPackFinders);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("railways-client.toml"));
        Config.loadConfig(Config.SERVER_CONFIG, FMLPaths.CONFIGDIR.get().resolve("railways-common.toml"));
        MOD_EVENT_BUS.addListener(RailwaysClient::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> RailwaysClient::clientCtor);
    }

    private void setup(FMLCommonSetupEvent event) {
        setup.init();
    }

    public static ResourceLocation asResource(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.m_236039_(true, (DataProvider)new RailwaysSequencedAssemblyRecipeGen(gen));
            gen.m_236039_(true, (DataProvider)new RailwaysStandardRecipeGen(gen));
        }
        if (event.includeClient()) {
            PonderLocalization.provideRegistrateLang((AbstractRegistrate)REGISTRATE);
            gen.m_236039_(true, (DataProvider)new LangMerger(gen, MODID, "Steam 'n Rails", (LangPartial[])CRLangPartials.values()));
        }
    }

    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                LOGGER.error("Could not find Steam & Rails mod file info; built-in resource packs will be missing!");
                return;
            }
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource((consumer, constructor) -> consumer.accept(Pack.m_10430_((String)Railways.asResource("legacy_semaphore").toString(), (boolean)false, () -> new ModFilePackResources("Steam 'n Rails Legacy Semaphores", modFile, "resourcepacks/legacy_semaphore"), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_)));
            event.addRepositorySource((consumer, constructor) -> consumer.accept(Pack.m_10430_((String)Railways.asResource("green_signals").toString(), (boolean)false, () -> new ModFilePackResources("Steam 'n Rails Green Signals", modFile, "resourcepacks/green_signals"), (Pack.PackConstructor)constructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10527_)));
        }
    }

    @SubscribeEvent
    public void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ConductorEntityModel.LAYER_LOCATION, ConductorEntityModel::createBodyLayer);
        event.registerLayerDefinition(ConductorCapModel.LAYER_LOCATION, ConductorCapModel::createBodyLayer);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CRCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void registerClientCommands(RegisterClientCommandsEvent event) {
        CRCommands.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketSender.notifyServerVersion(() -> serverPlayer);
        }
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    private static String getVersion() {
        String versionString = "UNKNOWN";
        List infoList = ModList.get().getModFileById(MODID).getMods();
        if (infoList.size() > 1) {
            LOGGER.error("Multiple mods for MOD_ID: railways");
        }
        for (IModInfo info : infoList) {
            if (!info.getModId().equals(MODID)) continue;
            versionString = MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)info.getVersion());
            break;
        }
        return versionString;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        setup = new ModSetup();
        VERSION = Railways.getVersion();
        REGISTRATE = CreateRegistrate.create((String)MODID);
    }
}

