/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base;

import com.railwayteam.railways.Railways;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.tileEntity.IMultiTileContainer;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectedBlockEntity
extends SmartTileEntity
implements IMultiTileContainer {
    public static final int CAPACITY = 1;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank fluidContainer = new SmartFluidTank(1000, this::onFluidStackChanged);
    BlockPos controller;
    protected int width;
    protected int length;
    protected int height;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public ConnectedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.fluidContainer);
        this.refreshCapability();
        this.controller = pos;
        this.width = 1;
        this.length = 1;
        this.height = 1;
    }

    public float getFillState() {
        return (float)this.fluidContainer.getFluidAmount() / (float)this.fluidContainer.getCapacity();
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        Railways.LOGGER.error("tank now has " + newFluidStack.getAmount() + "mB");
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public void initialize() {
        super.initialize();
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (this.isController()) {
            tag.m_128365_("tankContents", (Tag)this.fluidContainer.writeToNBT(new CompoundTag()));
        } else {
            tag.m_128365_("controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("controller"));
        } else {
            this.fluidContainer.setCapacity(1000);
            this.fluidContainer.readFromNBT(tag.m_128469_("tankContents"));
            Railways.LOGGER.error("Updating tank from packet to contain " + this.fluidContainer.getFluidAmount());
        }
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.isController() ? this.fluidContainer : (this.getControllerTE() != null ? this.getControllerTE().fluidContainer : new FluidTank(0)));
        oldCap.invalidate();
    }

    public ConnectedBlockEntity getControllerTE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof ConnectedBlockEntity) {
            return (ConnectedBlockEntity)tileEntity;
        }
        return null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public BlockPos getController() {
        return this.f_58858_;
    }

    public boolean isController() {
        return true;
    }

    public void setController(BlockPos pos) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (pos.equals((Object)this.controller)) {
            return;
        }
        this.controller = pos;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
    }

    public BlockPos getLastKnownPos() {
        return this.m_58899_();
    }

    public void preventConnectivityUpdate() {
    }

    public void notifyMultiUpdated() {
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ConnectedBlockEntity.getMaxLength(width);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

