/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.Railways;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public abstract class RailwaysRecipeProvider
extends RecipeProvider {
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public RailwaysRecipeProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected void m_176531_(@NotNull Consumer<FinishedRecipe> p_200404_1_) {
        this.all.forEach(c -> c.register(p_200404_1_));
        Railways.LOGGER.info(this.m_6055_() + " registered " + this.all.size() + " recipe" + (this.all.size() == 1 ? "" : "s"));
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(Consumer<FinishedRecipe> var1);
    }

    public static class Ingredients {
        public static TagKey<Item> string() {
            return Tags.Items.STRING;
        }

        public static ItemLike precisionMechanism() {
            return (ItemLike)AllItems.PRECISION_MECHANISM.get();
        }

        public static TagKey<Item> ironNugget() {
            return AllTags.forgeItemTag((String)"nuggets/iron");
        }

        public static TagKey<Item> zincNugget() {
            return AllTags.forgeItemTag((String)"nuggets/zinc");
        }

        public static ItemLike girder() {
            return (ItemLike)AllBlocks.METAL_GIRDER.get();
        }

        public static ItemLike metalBracket() {
            return (ItemLike)AllBlocks.METAL_BRACKET.get();
        }

        public static ItemLike ironSheet() {
            return (ItemLike)AllItems.IRON_SHEET.get();
        }
    }
}

