/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.content.conductor.ConductorCapModel;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllBlocks;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class ConductorCapItem
extends ArmorItem {
    public final DyeColor color;

    public ConductorCapItem(Item.Properties props, DyeColor color) {
        super((ArmorMaterial)new ConductorArmorMaterial(), EquipmentSlot.HEAD, props);
        this.color = color;
    }

    static boolean isCasing(Block block) {
        return block.equals(AllBlocks.ANDESITE_CASING.get());
    }

    static boolean isCasing(BlockState state) {
        return ConductorCapItem.isCasing(state.m_60734_());
    }

    static boolean isCasing(Level level, BlockPos pos) {
        return ConductorCapItem.isCasing(level.m_8055_(pos));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        if (ConductorCapItem.isCasing(level, pos = ctx.m_8083_())) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            level.m_7471_(pos, false);
            ConductorEntity.spawn(level, pos, ctx.m_43722_().m_41777_());
            if (ctx.m_43723_() != null && !ctx.m_43723_().m_7500_()) {
                ctx.m_43722_().m_41774_(1);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(ctx);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nonnull
            public Model getGenericArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                EntityModelSet set = Minecraft.m_91087_().m_167973_();
                String name = itemStack.m_41786_().getString();
                PartialModel override = CRBlockPartials.CUSTOM_CONDUCTOR_CAPS.getOrDefault(name, null);
                ConductorCapModel model = new ConductorCapModel(set.m_171103_(ConductorCapModel.LAYER_LOCATION), override, CRBlockPartials.shouldPreventTiltingCap(itemStack));
                model.setProperties(_default);
                return model;
            }
        });
        super.initializeClient(consumer);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "railways:textures/entity/caps/" + this.color.m_41065_().toLowerCase(Locale.ROOT) + "_conductor_cap.png";
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return true;
    }

    static class ConductorArmorMaterial
    implements ArmorMaterial {
        ConductorArmorMaterial() {
        }

        public int m_7366_(EquipmentSlot slot) {
            return 0;
        }

        public int m_7365_(EquipmentSlot slot) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return null;
        }

        public String m_6082_() {
            return "conductor_cap";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

