/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxInventory;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxSlot;
import com.railwayteam.railways.registry.CRContainerTypes;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.gui.container.ContainerBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MountedToolboxContainer
extends ContainerBase<ConductorEntity> {
    public boolean renderPass;

    public MountedToolboxContainer(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public MountedToolboxContainer(MenuType<?> type, int id, Inventory inv, ConductorEntity entity) {
        super(type, id, inv, (Object)entity);
        if (entity.isCarryingToolbox()) {
            entity.getToolboxHolder().startOpen(this.player);
        }
    }

    public static MountedToolboxContainer create(int id, Inventory inv, ConductorEntity entity) {
        return new MountedToolboxContainer((MenuType)CRContainerTypes.MOUNTED_TOOLBOX.get(), id, inv, entity);
    }

    protected ConductorEntity createOnClient(FriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        int entity_id = extraData.readInt();
        Entity entity = world.m_6815_(entity_id);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductorEntity = (ConductorEntity)entity;
            conductorEntity.getOrCreateToolboxHolder().read(extraData.m_130260_(), true);
            return conductorEntity;
        }
        return null;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = this.m_38853_(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = clickedSlot.m_7993_();
        int size = ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.getSlots();
        boolean success = false;
        if (index < size) {
            success = !this.m_38903_(stack, size, this.f_38839_.size(), false);
            ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.onContentsChanged(index);
        } else {
            success = !this.m_38903_(stack, 0, size - 1, false);
        }
        return success ? ItemStack.f_41583_ : stack;
    }

    public void m_150399_(int index, int flags, ClickType type, Player player) {
        int size = ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.getSlots();
        if (index >= 0 && index < size) {
            int subIndex;
            ItemStack itemInClickedSlot = this.m_38853_(index).m_7993_();
            ItemStack carried = this.m_142621_();
            if (type == ClickType.PICKUP && !carried.m_41619_() && !itemInClickedSlot.m_41619_() && ToolboxInventory.canItemsShareCompartment((ItemStack)itemInClickedSlot, (ItemStack)carried) && (subIndex = index % 4) != 3) {
                this.m_150399_(index - subIndex + 4 - 1, flags, type, player);
                return;
            }
            if (type == ClickType.PICKUP && carried.m_41619_() && itemInClickedSlot.m_41619_() && !player.f_19853_.f_46443_) {
                ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.filters.set(index / 4, ItemStack.f_41583_);
                ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().sendData();
            }
        }
        super.m_150399_(index, flags, type, player);
    }

    public boolean m_5622_(Slot slot) {
        return slot.f_40219_ > ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.getSlots() && super.m_5622_(slot);
    }

    public ItemStack getFilter(int compartment) {
        return ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory.filters.get(compartment);
    }

    public int totalCountInCompartment(int compartment) {
        int count = 0;
        int baseSlot = compartment * 4;
        for (int i = 0; i < 4; ++i) {
            count += this.m_38853_(baseSlot + i).m_7993_().m_41613_();
        }
        return count;
    }

    protected void addSlots() {
        MountedToolboxInventory inventory = ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().inventory;
        int x = 79;
        int y = 37;
        int[] xOffsets = new int[]{x, x + 33, x + 66, x + 66 + 6, x + 66, x + 33, x, x - 6};
        int[] yOffsets = new int[]{y, y - 6, y, y + 33, y + 66, y + 66 + 6, y + 66, y + 33};
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            this.m_38897_((Slot)new MountedToolboxSlot(this, (IItemHandler)inventory, baseIndex, xOffsets[compartment], yOffsets[compartment]));
            for (int i = 1; i < 4; ++i) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, baseIndex + i, -10000, -10000));
            }
        }
        this.addPlayerSlots(8, 165);
    }

    protected void saveData(ConductorEntity contentHolder) {
    }

    protected void initAndReadInventory(ConductorEntity contentHolder) {
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (!playerIn.f_19853_.f_46443_ && ((ConductorEntity)((Object)this.contentHolder)).isCarryingToolbox()) {
            ((ConductorEntity)((Object)this.contentHolder)).getToolboxHolder().stopOpen(playerIn);
        }
    }
}

