/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxContainer;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxInventory;
import com.railwayteam.railways.mixin_interfaces.IMountedToolboxHandler;
import com.railwayteam.railways.util.packet.PacketSender;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MountedToolboxHolder
implements MenuProvider,
Nameable {
    public final LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public final LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    protected final ConductorEntity parent;
    UUID uniqueId;
    final MountedToolboxInventory inventory;
    LazyOptional<IItemHandler> inventoryProvider;
    DyeColor color;
    final Map<Integer, WeakHashMap<Player, Integer>> connectedPlayers;
    protected int openCount;
    private boolean initialized = false;
    protected int lazyTickCounter;
    protected int lazyTickRate;
    private Component customName;

    public MountedToolboxHolder(ConductorEntity parent, DyeColor dyeColor) {
        this.parent = parent;
        this.connectedPlayers = new HashMap<Integer, WeakHashMap<Player, Integer>>();
        this.inventory = new MountedToolboxInventory(this);
        this.inventoryProvider = LazyOptional.of(() -> this.inventory);
        this.color = dyeColor;
        this.setLazyTickRate(10);
    }

    public void readFromItem(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        this.readInventory(tag.m_128469_("Inventory"));
        if (tag.m_128441_("UniqueId")) {
            this.setUniqueId(tag.m_128342_("UniqueId"));
        }
        if (stack.m_41788_()) {
            this.setCustomName(stack.m_41786_());
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    public ConductorEntity getParent() {
        return this.parent;
    }

    public void initialize() {
        IMountedToolboxHandler.onLoad(this.parent);
        this.lazyTick();
    }

    public void setRemoved() {
        IMountedToolboxHandler.onUnload(this.parent);
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void tick() {
        if (!this.initialized && this.getLevel() != null) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        if (this.getLevel().f_46443_) {
            this.tickAudio();
        } else {
            this.tickPlayers();
        }
        this.lid.chase(this.openCount > 0 ? 1.0 : 0.0, (double)0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openCount > 0 ? 1.0 : 0.0, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    public List<Player> getConnectedPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> entry : this.connectedPlayers.entrySet()) {
            players.addAll(entry.getValue().keySet());
        }
        return players.stream().toList();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<Player, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            ItemStack referenceItem = this.inventory.filters.get(slot);
            boolean clear = referenceItem.m_41619_();
            Iterator<Map.Entry<Player, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                int deposited;
                int targetAmount;
                Map.Entry<Player, Integer> playerEntry = playerEntries.next();
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !IMountedToolboxHandler.withinRange(player, this.parent)) continue;
                Inventory playerInv = player.m_150109_();
                ItemStack playerStack = playerInv.m_8020_(hotbarSlot);
                if (clear || !playerStack.m_41619_() && !MountedToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    player.getPersistentData().m_128469_("CreateToolboxData").m_128473_(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof ServerPlayer)) continue;
                    ToolboxHandler.syncData((Player)player);
                    continue;
                }
                int count = playerStack.m_41613_();
                if (count < (targetAmount = (referenceItem.m_41741_() + 1) / 2)) {
                    ItemStack extracted;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player) && !(extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, true)).m_41619_()) {
                        ToolboxHandler.unequip((Player)player, (int)hotbarSlot, (boolean)false);
                        ToolboxHandler.syncData((Player)player);
                        continue;
                    }
                    extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.m_41619_()) {
                        update = true;
                        ItemStack template = playerStack.m_41619_() ? extracted : playerStack;
                        playerInv.m_6836_(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)template, (int)(count + extracted.m_41613_())));
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                ItemStack toDistribute = ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)amountToDeposit);
                if (this.isOpenInContainer(player) && (deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, true).m_41613_()) > 0) {
                    ToolboxHandler.unequip((Player)player, (int)hotbarSlot, (boolean)true);
                    ToolboxHandler.syncData((Player)player);
                    continue;
                }
                int deposited2 = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, false).m_41613_();
                if (deposited2 <= 0) continue;
                update = true;
                playerInv.m_6836_(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)(count - deposited2)));
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    private boolean isOpenInContainer(Player player) {
        return player.f_36096_ instanceof MountedToolboxContainer && ((MountedToolboxContainer)player.f_36096_).contentHolder == this.parent;
    }

    public void unequipTracked() {
        if (this.parent.f_19853_.f_46443_) {
            return;
        }
        HashSet<ServerPlayer> affected = new HashSet<ServerPlayer>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<Player, Integer> playerEntry : set.entrySet()) {
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip((Player)player, (int)hotbarSlot, (boolean)false);
                if (!(player instanceof ServerPlayer)) continue;
                affected.add((ServerPlayer)player);
            }
        }
        for (ServerPlayer player : affected) {
            ToolboxHandler.syncData((Player)player);
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, Player player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        Inventory playerInv = player.m_150109_();
        ItemStack playerStack = playerInv.m_8020_(hotbarSlot);
        ItemStack toInsert = ToolboxInventory.cleanItemNBT((ItemStack)playerStack.m_41777_());
        ItemStack remainder = this.inventory.distributeToCompartment(toInsert, slot, false);
        if (remainder.m_41613_() != toInsert.m_41613_()) {
            playerInv.m_6836_(hotbarSlot, remainder);
        }
    }

    private void tickAudio() {
        Vec3 vec = this.parent.m_20182_();
        if (this.lid.settled()) {
            if (this.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.getLevel().m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_12056_, SoundSource.BLOCKS, 0.25f, this.getLevel().f_46441_.m_188501_() * 0.1f + 1.2f, true);
                this.getLevel().m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.1f, this.getLevel().f_46441_.m_188501_() * 0.1f + 1.1f, true);
            }
            if (this.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.getLevel().m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.1f, this.getLevel().f_46441_.m_188501_() * 0.1f + 1.1f, true);
            }
        } else if (this.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.getLevel().m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.25f, this.getLevel().f_46441_.m_188501_() * 0.1f + 1.2f, true);
        }
    }

    public void sendData() {
        if (this.parent.f_19853_.f_46443_) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.write(nbt, true);
        PacketSender.syncMountedToolboxNBT((Entity)this.parent, nbt);
    }

    public Level getLevel() {
        return this.parent.m_9236_();
    }

    public void setChanged() {
    }

    public void lazyTick() {
        this.updateOpenCount();
        IMountedToolboxHandler.onLoad(this.parent);
    }

    void updateOpenCount() {
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.openCount == 0) {
            return;
        }
        int prevOpenCount = this.openCount;
        this.openCount = 0;
        for (Player playerentity : this.getLevel().m_45976_(Player.class, new AABB(this.parent.m_20182_(), this.parent.m_20182_()).m_82400_(8.0))) {
            if (!(playerentity.f_36096_ instanceof MountedToolboxContainer) || ((MountedToolboxContainer)playerentity.f_36096_).contentHolder != this.parent) continue;
            ++this.openCount;
        }
        this.sendData();
    }

    public void startOpen(Player player) {
        if (player.m_5833_()) {
            return;
        }
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        this.sendData();
    }

    public void stopOpen(Player player) {
        if (player.m_5833_()) {
            return;
        }
        --this.openCount;
        this.sendData();
    }

    public static MountedToolboxHolder read(ConductorEntity parent, CompoundTag compound) {
        MountedToolboxHolder holder = new MountedToolboxHolder(parent, DyeColor.BROWN);
        holder.read(compound, false);
        return holder;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        if (compound.m_128425_("Color", 3)) {
            this.color = DyeColor.m_41053_((int)compound.m_128451_("Color"));
        }
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        if (compound.m_128425_("UniqueId", 11)) {
            this.uniqueId = compound.m_128342_("UniqueId");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        if (clientPacket) {
            this.openCount = compound.m_128451_("OpenCount");
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Color", this.color.m_41060_());
        if (this.uniqueId == null) {
            this.uniqueId = UUID.randomUUID();
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128362_("UniqueId", this.uniqueId);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (clientPacket) {
            compound.m_128405_("OpenCount", this.openCount);
        }
    }

    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return MountedToolboxContainer.create(id, inv, this.parent);
    }

    public void connectPlayer(int slot, Player player, int hotbarSlot) {
        if (this.parent.f_19853_.f_46443_) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip((Player)player, (int)previous, (boolean)false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(CompoundTag compoundTag) {
        this.inventory.deserializeNBT(compoundTag);
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isFullyInitialized() {
        return this.uniqueId != null;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    @NotNull
    public Component m_5446_() {
        return this.customName != null ? this.customName : ((ToolboxBlock)AllBlocks.TOOLBOXES.get(this.getColor()).get()).m_49954_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @NotNull
    public Component m_7755_() {
        return this.customName;
    }

    public ItemStack getDisplayStack() {
        ItemStack stack = new ItemStack((ItemLike)AllBlocks.TOOLBOXES.get(this.getColor()).get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public void sendToContainer(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.parent.m_19879_());
        CompoundTag compound = new CompoundTag();
        this.write(compound, true);
        friendlyByteBuf.m_130079_(compound);
    }

    public ItemStack getCloneItemStack() {
        ItemStack stack = this.getDisplayStack();
        CompoundTag tag = stack.m_41784_();
        CompoundTag inv = this.inventory.serializeNBT();
        tag.m_128365_("Inventory", (Tag)inv);
        tag.m_128362_("UniqueId", this.getUniqueId());
        return stack;
    }

    public LazyOptional<IItemHandler> getInventoryProvider() {
        return this.inventoryProvider;
    }

    public void invalidateCaps() {
        this.inventoryProvider.invalidate();
    }

    public void reviveCaps() {
        this.inventoryProvider = LazyOptional.of(() -> this.inventory);
    }
}

