/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxContainer;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolboxDisposeAllPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MountedToolboxScreen
extends AbstractSimiContainerScreen<MountedToolboxContainer> {
    protected static final AllGuiTextures BG = AllGuiTextures.TOOLBOX;
    protected static final AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;
    protected Slot hoveredToolboxSlot;
    private IconButton confirmButton;
    private IconButton disposeButton;
    private DyeColor color;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public MountedToolboxScreen(MountedToolboxContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.m_7856_();
    }

    protected void m_7856_() {
        this.setWindowSize(30 + MountedToolboxScreen.BG.width, MountedToolboxScreen.BG.height + MountedToolboxScreen.PLAYER.height - 24);
        this.setWindowOffset(-11, 0);
        super.m_7856_();
        this.color = ((ConductorEntity)((Object)((MountedToolboxContainer)this.f_97732_).contentHolder)).getToolboxHolder().getColor();
        this.confirmButton = new IconButton(this.f_97735_ + 30 + MountedToolboxScreen.BG.width - 33, this.f_97736_ + MountedToolboxScreen.BG.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.disposeButton = new IconButton(this.f_97735_ + 30 + 81, this.f_97736_ + 69, (ScreenElement)AllIcons.I_TOOLBOX);
        this.disposeButton.withCallback(() -> CRPackets.channel.sendToServer((Object)new MountedToolboxDisposeAllPacket((ConductorEntity)((Object)((Object)((MountedToolboxContainer)this.f_97732_).contentHolder)))));
        this.disposeButton.setToolTip((Component)Lang.translateDirect((String)"toolbox.depositBox", (Object[])new Object[0]));
        this.m_142416_((GuiEventListener)this.disposeButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.f_97735_ + 30 + MountedToolboxScreen.BG.width, this.f_97736_ + MountedToolboxScreen.BG.height - 15 - 34 - 6, 72, 68));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((MountedToolboxContainer)this.f_97732_).renderPass = true;
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        ((MountedToolboxContainer)this.f_97732_).renderPass = false;
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        int x = this.f_97735_ + this.f_97726_ - MountedToolboxScreen.BG.width;
        int y = this.f_97736_;
        BG.render(ms, x, y, (GuiComponent)this);
        this.f_96547_.m_92889_(ms, this.f_96539_, (float)(x + 15), (float)(y + 4), 0x442000);
        int invX = this.f_97735_;
        int invY = this.f_97736_ + this.f_97727_ - MountedToolboxScreen.PLAYER.height;
        this.renderPlayerInventory(ms, invX, invY);
        this.renderToolbox(ms, x + MountedToolboxScreen.BG.width + 50, y + MountedToolboxScreen.BG.height + 12, partialTicks);
        this.hoveredToolboxSlot = null;
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            Slot slot = (Slot)((MountedToolboxContainer)this.f_97732_).f_38839_.get(baseIndex);
            ItemStack itemstack = slot.m_7993_();
            int i = slot.f_40220_ + this.f_97735_;
            int j = slot.f_40221_ + this.f_97736_;
            if (itemstack.m_41619_()) {
                itemstack = ((MountedToolboxContainer)this.f_97732_).getFilter(compartment);
            }
            if (!itemstack.m_41619_()) {
                int count = ((MountedToolboxContainer)this.f_97732_).totalCountInCompartment(compartment);
                String s = String.valueOf(count);
                this.m_93250_(100);
                this.f_96542_.f_115093_ = 100.0f;
                RenderSystem.m_69482_();
                this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, itemstack, i, j, 0);
                this.f_96542_.m_115174_(this.f_96547_, itemstack, i, j, s);
                this.m_93250_(0);
                this.f_96542_.f_115093_ = 0.0f;
            }
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY)) continue;
            this.hoveredToolboxSlot = slot;
            RenderSystem.m_69465_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int slotColor = this.getSlotColor(baseIndex);
            this.m_93179_(ms, i, j, i + 16, j + 16, slotColor, slotColor);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_69482_();
        }
    }

    private void renderToolbox(PoseStack ms, int x, int y, float partialTicks) {
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).pushPose()).translate((double)x, (double)y, 100.0)).scale(50.0f)).rotateX(-22.0)).rotateY(-202.0);
        GuiGameElement.of((BlockState)AllBlocks.TOOLBOXES.get(this.color).getDefaultState()).render(ms);
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).pushPose()).translate(0.0, -0.375, 0.75)).rotateX((double)(-105.0f * ((ConductorEntity)((Object)((MountedToolboxContainer)this.f_97732_).contentHolder)).getToolboxHolder().lid.getValue(partialTicks)))).translate(0.0, 0.375, -0.75);
        GuiGameElement.of((PartialModel)((PartialModel)AllBlockPartials.TOOLBOX_LIDS.get(this.color))).render(ms);
        ms.m_85849_();
        for (int offset : Iterate.zeroAndOne) {
            ms.m_85836_();
            ms.m_85837_(0.0, (double)((float)(-offset) / 8.0f), (double)(((ConductorEntity)((Object)((MountedToolboxContainer)this.f_97732_).contentHolder)).getToolboxHolder().drawers.getValue(partialTicks) * -0.175f * (float)(2 - offset)));
            GuiGameElement.of((PartialModel)AllBlockPartials.TOOLBOX_DRAWER).render(ms);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    protected void renderForeground(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredToolboxSlot != null) {
            this.f_97734_ = this.hoveredToolboxSlot;
        }
        super.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

