/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.railwayteam.railways.Config;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRSounds;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBlockItem;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConductorWhistleItem
extends TrackTargetingBlockItem {
    public static final String SPECIAL_MARKER = "<ConductorFlag>";

    public ConductorWhistleItem(Block block, Item.Properties properties) {
        super(block, properties, EdgePointType.STATION);
    }

    static boolean isTrack(Block block) {
        return CRTags.AllBlockTags.TRACKS.matches(block);
    }

    static boolean isTrack(BlockState state) {
        return CRTags.AllBlockTags.TRACKS.matches(state);
    }

    static boolean isTrack(Level level, BlockPos pos) {
        return ConductorWhistleItem.isTrack(level.m_8055_(pos));
    }

    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        return false;
    }

    private static InteractionResult fail(Player player, String message) {
        player.m_5661_((Component)Components.translatable((String)("railways.whistle.failure." + message)).m_130940_(ChatFormatting.RED), true);
        player.m_5661_((Component)Components.translatable((String)("railways.whistle.failure." + message)).m_130940_(ChatFormatting.RED), false);
        return InteractionResult.FAIL;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_("SelectedTrain") && tag.m_128403_("SelectedConductor")) {
            UUID trainId = tag.m_128342_("SelectedTrain");
            UUID conductorId = tag.m_128342_("SelectedConductor");
            String trainName = "NOT FOUND";
            GlobalRailwayManager railways = Create.RAILWAYS.sided((LevelAccessor)level);
            if (railways != null && railways.trains.containsKey(trainId)) {
                trainName = ((Train)railways.trains.get((Object)trainId)).name.getString();
            }
            tooltip.add((Component)Components.translatable((String)"railways.whistle.tool.bound").m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.train_id", trainName, trainId.toString().substring(0, 5)));
            tooltip.add((Component)Components.translatable((String)"railways.whistle.tool.bound_usage"));
        } else {
            tooltip.add((Component)Components.translatable((String)"railways.whistle.tool.not_bound").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ConductorEntity conductor;
        Entity entity;
        if (pPlayer.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        if (pInteractionTarget instanceof ConductorEntity && (entity = (conductor = (ConductorEntity)pInteractionTarget).m_20202_()) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Train train = cce.getCarriage().train;
            if (train.owner == pPlayer.m_20148_() || !((Boolean)Config.CONDUCTOR_WHISTLE_REQUIRES_OWNING.get()).booleanValue()) {
                CompoundTag stackTag = pStack.m_41784_();
                stackTag.m_128362_("SelectedTrain", train.id);
                stackTag.m_128362_("SelectedConductor", conductor.m_20148_());
                stackTag.m_128344_("SelectedColor", ((Byte)conductor.m_20088_().m_135370_(ConductorEntity.COLOR)).byteValue());
                pPlayer.m_5661_((Component)Components.translatable((String)"railways.whistle.set"), true);
                pStack.m_41751_(stackTag);
                pPlayer.m_21008_(pUsedHand, pStack);
                AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.f_19853_, null, conductor.m_20185_(), conductor.m_20186_(), conductor.m_20189_(), 0.5f, 1.1f);
                return InteractionResult.SUCCESS;
            }
            pPlayer.m_5661_((Component)Component.m_237115_((String)"railways.whistle.not_owner").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_20161_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Components.translatable((String)"railways.whistle.clear"), true);
            stack.m_41751_(null);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        Block block = state.m_60734_();
        if (block instanceof ITrackBlock) {
            ItemStack scheduleStack;
            ITrackBlock track = (ITrackBlock)block;
            level.m_5594_(null, pos, (SoundEvent)CRSounds.CONDUCTOR_WHISTLE.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.m_20154_();
            boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
            EdgePointType type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            ConductorWhistleItem.withGraphLocation((Level)level, (BlockPos)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.m_5661_((Component)Lang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            CompoundTag stackTag = stack.m_41783_();
            if (stackTag == null || !stackTag.m_128403_("SelectedTrain") || !stackTag.m_128403_("SelectedConductor")) {
                return ConductorWhistleItem.fail(player, "not_bound");
            }
            UUID trainId = stackTag.m_128342_("SelectedTrain");
            UUID conductorId = stackTag.m_128342_("SelectedConductor");
            if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                return ConductorWhistleItem.fail(player, "train_missing");
            }
            Train train = (Train)Create.RAILWAYS.trains.get(trainId);
            boolean foundConductor = false;
            for (Carriage carriage : train.carriages) {
                if (!((ICarriageConductors)carriage).getControllingConductors().contains(conductorId)) continue;
                foundConductor = true;
                break;
            }
            if (!foundConductor) {
                return ConductorWhistleItem.fail(player, "conductor_missing");
            }
            stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            stackTag.m_128379_("SelectedDirection", front);
            stackTag.m_128473_("Bezier");
            stack.m_41751_(stackTag);
            Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
            Direction successDirection = null;
            for (Direction direction : directions) {
                BlockPos placePos = pos.m_121945_(direction);
                Vec3 hitPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5).m_82520_((double)direction.m_122429_() * 0.5, (double)direction.m_122430_() * 0.5, (double)direction.m_122431_() * 0.5);
                if (!level.m_8055_(placePos).m_60629_(new BlockPlaceContext(level, player, pContext.m_43724_(), stack, new BlockHitResult(hitPos, direction.m_122424_(), placePos, false)))) continue;
                successDirection = direction;
                break;
            }
            if (successDirection == null) {
                stackTag.m_128473_("SelectedPos");
                stackTag.m_128473_("SelectedDirection");
                stack.m_41751_(stackTag);
                return ConductorWhistleItem.fail(player, "no_space");
            }
            if (((Boolean)Config.CONDUCTOR_WHISTLE_REQUIRES_OWNING.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != player) {
                stackTag.m_128473_("SelectedPos");
                stackTag.m_128473_("SelectedDirection");
                stack.m_41751_(stackTag);
                return ConductorWhistleItem.fail(player, "not_owner");
            }
            if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !player.m_36356_(scheduleStack = train.runtime.returnSchedule())) {
                player.m_36176_(scheduleStack, false);
            }
            BlockPos placePos = pos.m_121945_(successDirection);
            String stationName = SPECIAL_MARKER + placePos.m_123344_();
            BlockState placeState = CRBlocks.CONDUCTOR_WHISTLE_FLAG.getDefaultState();
            level.m_7731_(placePos, placeState, 11);
            CompoundTag teTag = new CompoundTag();
            teTag.m_128359_("Name", stationName);
            teTag.m_128344_("SelectedColor", stackTag.m_128445_("SelectedColor"));
            teTag.m_128379_("TargetDirection", stackTag.m_128471_("SelectedDirection"));
            BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)stackTag.m_128469_("SelectedPos"));
            teTag.m_128365_("TargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placePos)));
            stackTag.m_128365_("BlockEntityTag", (Tag)teTag);
            stack.m_41751_(stackTag);
            this.m_7274_(placePos, level, player, stack, placeState);
            stackTag.m_128473_("SelectedPos");
            stackTag.m_128473_("SelectedDirection");
            stackTag.m_128473_("BlockEntityTag");
            stack.m_41751_(stackTag);
            player.m_5661_((Component)Components.translatable((String)"railways.whistle.success"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 1.0f);
            Schedule schedule = new Schedule();
            ScheduleEntry entry = new ScheduleEntry();
            DestinationInstruction instruction = new DestinationInstruction();
            ScheduledDelay condition = new ScheduledDelay();
            condition.getData().m_128405_("Value", 0);
            instruction.getData().m_128359_("Text", stationName);
            entry.instruction = instruction;
            if (entry.conditions.size() == 0) {
                entry.conditions.add(new ArrayList());
            }
            ((List)entry.conditions.get(0)).add(condition);
            schedule.entries.add(entry);
            schedule.cyclic = false;
            train.runtime.setSchedule(schedule, true);
            ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

