/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.custom_tracks.TrackMaterial;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IHasTrackMaterial;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.ITrackBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackRenderer;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CustomTrackOverlayRendering {
    public static final Map<EdgePointType<?>, PartialModel> CUSTOM_OVERLAYS = new HashMap();

    public static void register(EdgePointType<?> edgePointType, PartialModel model) {
        CUSTOM_OVERLAYS.put(edgePointType, model);
    }

    @Nullable
    public static PartialModel getCouplerOverlayModel(boolean couple, boolean decouple) {
        if (couple && decouple) {
            return CRBlockPartials.COUPLER_BOTH;
        }
        if (couple) {
            return CRBlockPartials.COUPLER_COUPLE;
        }
        if (decouple) {
            return CRBlockPartials.COUPLER_DECOUPLE;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, EdgePointType<?> type, float scale) {
        if (CUSTOM_OVERLAYS.containsKey(type)) {
            CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, CUSTOM_OVERLAYS.get(type), scale, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale) {
        CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, model, scale, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale, boolean offsetToSide) {
        if (level instanceof SchematicWorld && !(level instanceof PonderWorld)) {
            return;
        }
        BlockState trackState = level.m_8055_(pos);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        PartialModel partial = CustomTrackOverlayRendering.prepareTrackOverlay((BlockGetter)level, pos, trackState, bezier, direction, ms, model);
        if (partial != null) {
            ((SuperByteBuffer)CachedBufferer.partial((PartialModel)partial, (BlockState)trackState).translate(0.5, 0.0, 0.5).scale(scale)).translate(offsetToSide ? 0.5 : -0.5, 0.0, -0.5).light(LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos)).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        }
        ms.m_85849_();
    }

    /*
     * Unable to fully structure code
     */
    @OnlyIn(value=Dist.CLIENT)
    public static PartialModel prepareTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, PartialModel model) {
        msr = TransformStack.cast((PoseStack)ms);
        axis = null;
        diff = null;
        normal = null;
        offset = null;
        if (bezierPoint != null && (var13_12 = world.m_7702_(pos)) instanceof TrackTileEntity) {
            trackTE = (TrackTileEntity)var13_12;
            bc = (BezierConnection)trackTE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                length = Mth.m_14107_((double)(bc.getLength() * 2.0));
                seg = bezierPoint.segment() + 1;
                t = (double)seg / length;
                tpre = (double)(seg - 1) / length;
                tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).m_82546_(bc.getPosition(tpre)).m_82541_();
                msr.translate(offset.m_82546_(Vec3.m_82539_((Vec3i)pos)));
                msr.translate(0.0, -0.25, 0.0);
                casingBc = (IHasTrackCasing)bc;
                if (((IHasTrackMaterial)bc).getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
                    msr.translate(0.0, 0.875, 0.0);
                } else if (casingBc.getTrackCasing() != null) {
                    if (((BlockPos)bc.tePositions.getFirst()).m_123342_() == ((BlockPos)bc.tePositions.getSecond()).m_123342_()) {
                        msr.translate(0.0, 0.0625, 0.0);
                    } else if (!casingBc.isAlternate()) {
                        msr.translate(0.0, 0.25, 0.0);
                    }
                }
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = (Vec3)((TrackShape)state.m_61143_((Property)TrackBlock.SHAPE)).getAxes().get(0);
            diff = axis.m_82490_((double)direction.m_122540_()).m_82541_();
            normal = ((ITrackBlock)state.m_60734_()).getUpNormal(world, pos, state);
        }
        if (bezierPoint != null || !((length = state.m_60734_()) instanceof IHasTrackMaterial)) ** GOTO lbl-1000
        material = (IHasTrackMaterial)length;
        if (material.getMaterial().trackType == TrackMaterial.TrackType.MONORAIL) {
            msr.translate(0.0, 0.875, 0.0);
        } else if (bezierPoint == null && (length = world.m_7702_(pos)) instanceof TrackTileEntity) {
            trackTE = (TrackTileEntity)length;
            casingTE = (IHasTrackCasing)trackTE;
            shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
            if (casingTE.getTrackCasing() != null && (spec = CRBlockPartials.TRACK_CASINGS.get(shape)) != null) {
                msr.translate(spec.getXShift(), (double)((float)(spec.getTopSurfacePixelHeight(casingTE.isAlternate()) - 2) / 16.0f), spec.getZShift());
            }
        }
        angles = TrackRenderer.getModelAngles(normal, diff);
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateYRadians(angles.f_82480_)).rotateXRadians(angles.f_82479_)).unCentre();
        if (axis != null) {
            msr.translate(0.0, axis.f_82480_ != 0.0 ? 0.4375 : 0.0, axis.f_82480_ != 0.0 ? (double)((float)direction.m_122540_() * 2.5f / 16.0f) : 0.0);
        } else {
            msr.translate(0.0, 0.25, 0.0);
            if (direction == Direction.AxisDirection.NEGATIVE) {
                msr.rotateCentered(Direction.UP, 3.1415927f);
            }
        }
        return model;
    }
}

